/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.textstructure.transport;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.ParentTaskAssigningClient;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.utils.MapHelper;
import org.elasticsearch.xpack.core.textstructure.action.AbstractFindStructureRequest;
import org.elasticsearch.xpack.core.textstructure.action.FindFieldStructureAction;
import org.elasticsearch.xpack.core.textstructure.action.FindStructureResponse;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinder;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureFinderManager;
import org.elasticsearch.xpack.textstructure.structurefinder.TextStructureOverrides;

public class TransportFindFieldStructureAction
extends HandledTransportAction<FindFieldStructureAction.Request, FindStructureResponse> {
    private final Client client;
    private final TransportService transportService;
    private final ThreadPool threadPool;

    @Inject
    public TransportFindFieldStructureAction(TransportService transportService, ActionFilters actionFilters, Client client, ThreadPool threadPool) {
        super("cluster:monitor/text_structure/find_field_structure", transportService, actionFilters, FindFieldStructureAction.Request::new, (Executor)threadPool.generic());
        this.client = client;
        this.transportService = transportService;
        this.threadPool = threadPool;
    }

    protected void doExecute(Task task, FindFieldStructureAction.Request request, ActionListener<FindStructureResponse> listener) {
        TaskId taskId = new TaskId(this.transportService.getLocalNode().getId(), task.getId());
        new ParentTaskAssigningClient(this.client, taskId).prepareSearch(new String[]{request.getIndex()}).setSize(request.getLinesToSample().intValue()).setFetchSource(true).setQuery((QueryBuilder)QueryBuilders.existsQuery((String)request.getField())).setFetchSource(new String[]{request.getField()}, null).execute(ActionListener.wrap(searchResponse -> {
            long hitCount = searchResponse.getHits().getHits().length;
            if (hitCount < 2L) {
                listener.onFailure((Exception)new IllegalArgumentException("Input contained too few lines [" + hitCount + "] to obtain a meaningful sample"));
                return;
            }
            List<String> messages = this.getMessages((SearchResponse)searchResponse, request.getField());
            try {
                listener.onResponse((Object)this.buildTextStructureResponse(messages, request));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private List<String> getMessages(SearchResponse searchResponse, String field) {
        return Arrays.stream(searchResponse.getHits().getHits()).map(hit -> MapHelper.dig((String)field, (Map)Objects.requireNonNull(hit.getSourceAsMap())).toString()).collect(Collectors.toList());
    }

    private FindStructureResponse buildTextStructureResponse(List<String> messages, FindFieldStructureAction.Request request) throws Exception {
        TextStructureFinderManager structureFinderManager = new TextStructureFinderManager(this.threadPool.scheduler());
        TextStructureFinder textStructureFinder = structureFinderManager.findTextStructure(messages, new TextStructureOverrides((AbstractFindStructureRequest)request), request.getTimeout());
        return new FindStructureResponse(textStructureFinder.getStructure());
    }
}

