/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.search.Query;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.xpack.security.support.SecurityIndexFieldNameTranslator;

public class UserBoolQueryBuilder
extends BoolQueryBuilder {
    public static final SecurityIndexFieldNameTranslator USER_FIELD_NAME_TRANSLATOR = new SecurityIndexFieldNameTranslator(List.of(SecurityIndexFieldNameTranslator.exact("username"), SecurityIndexFieldNameTranslator.exact("roles"), SecurityIndexFieldNameTranslator.exact("full_name"), SecurityIndexFieldNameTranslator.exact("email"), SecurityIndexFieldNameTranslator.exact("enabled")));

    private UserBoolQueryBuilder() {
    }

    public static UserBoolQueryBuilder build(QueryBuilder queryBuilder) {
        UserBoolQueryBuilder userQueryBuilder = new UserBoolQueryBuilder();
        if (queryBuilder != null) {
            QueryBuilder translaterdQueryBuilder = UserBoolQueryBuilder.translateToUserQueryBuilder(queryBuilder);
            userQueryBuilder.must(translaterdQueryBuilder);
        }
        userQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"user"));
        return userQueryBuilder;
    }

    private static QueryBuilder translateToUserQueryBuilder(QueryBuilder qb) {
        if (qb instanceof BoolQueryBuilder) {
            BoolQueryBuilder query = (BoolQueryBuilder)qb;
            BoolQueryBuilder newQuery = QueryBuilders.boolQuery().minimumShouldMatch(query.minimumShouldMatch()).adjustPureNegative(query.adjustPureNegative());
            query.must().stream().map(UserBoolQueryBuilder::translateToUserQueryBuilder).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).must(arg_0));
            query.should().stream().map(UserBoolQueryBuilder::translateToUserQueryBuilder).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).should(arg_0));
            query.mustNot().stream().map(UserBoolQueryBuilder::translateToUserQueryBuilder).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).mustNot(arg_0));
            query.filter().stream().map(UserBoolQueryBuilder::translateToUserQueryBuilder).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).filter(arg_0));
            return newQuery;
        }
        if (qb instanceof MatchAllQueryBuilder) {
            return qb;
        }
        if (qb instanceof TermQueryBuilder) {
            TermQueryBuilder query = (TermQueryBuilder)qb;
            String translatedFieldName = USER_FIELD_NAME_TRANSLATOR.translate(query.fieldName());
            return QueryBuilders.termQuery((String)translatedFieldName, (Object)query.value()).caseInsensitive(query.caseInsensitive());
        }
        if (qb instanceof ExistsQueryBuilder) {
            ExistsQueryBuilder query = (ExistsQueryBuilder)qb;
            String translatedFieldName = USER_FIELD_NAME_TRANSLATOR.translate(query.fieldName());
            return QueryBuilders.existsQuery((String)translatedFieldName);
        }
        if (qb instanceof TermsQueryBuilder) {
            TermsQueryBuilder query = (TermsQueryBuilder)qb;
            if (query.termsLookup() != null) {
                throw new IllegalArgumentException("Terms query with terms lookup is not supported for User query");
            }
            String translatedFieldName = USER_FIELD_NAME_TRANSLATOR.translate(query.fieldName());
            return QueryBuilders.termsQuery((String)translatedFieldName, (Collection)query.getValues());
        }
        if (qb instanceof PrefixQueryBuilder) {
            PrefixQueryBuilder query = (PrefixQueryBuilder)qb;
            String translatedFieldName = USER_FIELD_NAME_TRANSLATOR.translate(query.fieldName());
            return QueryBuilders.prefixQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive());
        }
        if (qb instanceof WildcardQueryBuilder) {
            WildcardQueryBuilder query = (WildcardQueryBuilder)qb;
            String translatedFieldName = USER_FIELD_NAME_TRANSLATOR.translate(query.fieldName());
            return QueryBuilders.wildcardQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive()).rewrite(query.rewrite());
        }
        throw new IllegalArgumentException("Query type [" + qb.getName() + "] is not supported for User query");
    }

    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        context.setAllowedFields(this::isIndexFieldNameAllowed);
        return super.doToQuery(context);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (queryRewriteContext instanceof SearchExecutionContext) {
            ((SearchExecutionContext)queryRewriteContext).setAllowedFields(this::isIndexFieldNameAllowed);
        }
        return super.doRewrite(queryRewriteContext);
    }

    boolean isIndexFieldNameAllowed(String queryFieldName) {
        return queryFieldName.equals("type") || USER_FIELD_NAME_TRANSLATOR.supportedIndexFieldName(queryFieldName);
    }
}

