/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class SecurityIndexFieldNameTranslator {
    private final List<FieldName> fieldNameTranslators;

    public SecurityIndexFieldNameTranslator(List<FieldName> fieldNameTranslators) {
        this.fieldNameTranslators = fieldNameTranslators;
    }

    public String translate(String queryFieldName) {
        for (FieldName fieldName : this.fieldNameTranslators) {
            if (!fieldName.supportsQueryName(queryFieldName)) continue;
            return fieldName.indexFieldName(queryFieldName);
        }
        throw new IllegalArgumentException("Field [" + queryFieldName + "] is not allowed");
    }

    public boolean supportedIndexFieldName(String indexFieldName) {
        for (FieldName fieldName : this.fieldNameTranslators) {
            if (!fieldName.supportsIndexName(indexFieldName)) continue;
            return true;
        }
        return false;
    }

    public static FieldName exact(String name) {
        return SecurityIndexFieldNameTranslator.exact(name, Function.identity());
    }

    public static FieldName exact(String name, Function<String, String> translation) {
        return new FieldName(name, translation);
    }

    public static class FieldName {
        private final String name;
        private final Function<String, String> toIndexFieldName;
        protected final Predicate<String> validIndexNamePredicate;

        private FieldName(String name, Function<String, String> toIndexFieldName) {
            this.name = name;
            this.toIndexFieldName = toIndexFieldName;
            this.validIndexNamePredicate = fieldName -> ((String)toIndexFieldName.apply(name)).equals(fieldName);
        }

        public boolean supportsQueryName(String queryFieldName) {
            return queryFieldName.equals(this.name);
        }

        public boolean supportsIndexName(String indexFieldName) {
            return this.validIndexNamePredicate.test(indexFieldName);
        }

        public String indexFieldName(String queryFieldName) {
            return this.toIndexFieldName.apply(queryFieldName);
        }
    }
}

