/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.SimpleQueryStringBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.search.QueryParserHelper;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;

public class ApiKeyFieldNameTranslators {
    static final List<FieldNameTranslator> FIELD_NAME_TRANSLATORS = List.of(new ExactFieldNameTranslator(s -> "creator.principal", "username"), new ExactFieldNameTranslator(s -> "creator.realm", "realm_name"), new ExactFieldNameTranslator(s -> "name", "name"), new ExactFieldNameTranslator(s -> "runtime_key_type", "type"), new ExactFieldNameTranslator(s -> "creation_time", "creation"), new ExactFieldNameTranslator(s -> "expiration_time", "expiration"), new ExactFieldNameTranslator(s -> "api_key_invalidated", "invalidated"), new ExactFieldNameTranslator(s -> "invalidation_time", "invalidation"), new ExactFieldNameTranslator(s -> "metadata_flattened", "metadata"), new PrefixFieldNameTranslator(s -> "metadata_flattened." + s.substring("metadata.".length()), "metadata."));

    public static void translateFieldSortBuilders(List<FieldSortBuilder> fieldSortBuilders, SearchSourceBuilder searchSourceBuilder, @Nullable Consumer<String> visitor) {
        Consumer<String> fieldNameVisitor = visitor != null ? visitor : ignored -> {};
        fieldSortBuilders.forEach(fieldSortBuilder -> {
            if (fieldSortBuilder.getNestedSort() != null) {
                throw new IllegalArgumentException("nested sorting is not supported for API Key query");
            }
            if ("_doc".equals(fieldSortBuilder.getFieldName())) {
                searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
            } else {
                String translatedFieldName = ApiKeyFieldNameTranslators.translate(fieldSortBuilder.getFieldName());
                fieldNameVisitor.accept(translatedFieldName);
                if (translatedFieldName.equals(fieldSortBuilder.getFieldName())) {
                    searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
                } else {
                    FieldSortBuilder translatedFieldSortBuilder = ((FieldSortBuilder)new FieldSortBuilder(translatedFieldName).order(fieldSortBuilder.order())).missing(fieldSortBuilder.missing()).unmappedType(fieldSortBuilder.unmappedType()).setFormat(fieldSortBuilder.getFormat());
                    if (fieldSortBuilder.sortMode() != null) {
                        translatedFieldSortBuilder.sortMode(fieldSortBuilder.sortMode());
                    }
                    if (fieldSortBuilder.getNestedSort() != null) {
                        translatedFieldSortBuilder.setNestedSort(fieldSortBuilder.getNestedSort());
                    }
                    if (fieldSortBuilder.getNumericType() != null) {
                        translatedFieldSortBuilder.setNumericType(fieldSortBuilder.getNumericType());
                    }
                    searchSourceBuilder.sort((SortBuilder)translatedFieldSortBuilder);
                }
            }
        });
    }

    public static QueryBuilder translateQueryBuilderFields(QueryBuilder queryBuilder, @Nullable Consumer<String> visitor) {
        Consumer<String> fieldNameVisitor;
        Objects.requireNonNull(queryBuilder, "unsupported \"null\" query builder for field name translation");
        Consumer<String> consumer = fieldNameVisitor = visitor != null ? visitor : ignored -> {};
        if (queryBuilder instanceof BoolQueryBuilder) {
            BoolQueryBuilder query = (BoolQueryBuilder)queryBuilder;
            BoolQueryBuilder newQuery = (BoolQueryBuilder)((BoolQueryBuilder)QueryBuilders.boolQuery().minimumShouldMatch(query.minimumShouldMatch()).adjustPureNegative(query.adjustPureNegative()).boost(query.boost())).queryName(query.queryName());
            query.must().stream().map(q -> ApiKeyFieldNameTranslators.translateQueryBuilderFields(q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).must(arg_0));
            query.should().stream().map(q -> ApiKeyFieldNameTranslators.translateQueryBuilderFields(q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).should(arg_0));
            query.mustNot().stream().map(q -> ApiKeyFieldNameTranslators.translateQueryBuilderFields(q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).mustNot(arg_0));
            query.filter().stream().map(q -> ApiKeyFieldNameTranslators.translateQueryBuilderFields(q, fieldNameVisitor)).forEach(arg_0 -> ((BoolQueryBuilder)newQuery).filter(arg_0));
            return newQuery;
        }
        if (queryBuilder instanceof MatchAllQueryBuilder) {
            MatchAllQueryBuilder query = (MatchAllQueryBuilder)queryBuilder;
            return ((MatchAllQueryBuilder)QueryBuilders.matchAllQuery().boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof IdsQueryBuilder) {
            IdsQueryBuilder query = (IdsQueryBuilder)queryBuilder;
            return ((IdsQueryBuilder)QueryBuilders.idsQuery().addIds(query.ids().toArray(new String[0])).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof TermQueryBuilder) {
            TermQueryBuilder query = (TermQueryBuilder)queryBuilder;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((TermQueryBuilder)QueryBuilders.termQuery((String)translatedFieldName, (Object)query.value()).caseInsensitive(query.caseInsensitive()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof ExistsQueryBuilder) {
            ExistsQueryBuilder query = (ExistsQueryBuilder)queryBuilder;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((ExistsQueryBuilder)QueryBuilders.existsQuery((String)translatedFieldName).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof TermsQueryBuilder) {
            TermsQueryBuilder query = (TermsQueryBuilder)queryBuilder;
            if (query.termsLookup() != null) {
                throw new IllegalArgumentException("terms query with terms lookup is not supported for API Key query");
            }
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((TermsQueryBuilder)QueryBuilders.termsQuery((String)translatedFieldName, (Collection)query.getValues()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof PrefixQueryBuilder) {
            PrefixQueryBuilder query = (PrefixQueryBuilder)queryBuilder;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((PrefixQueryBuilder)QueryBuilders.prefixQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive()).rewrite(query.rewrite()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof WildcardQueryBuilder) {
            WildcardQueryBuilder query = (WildcardQueryBuilder)queryBuilder;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            return ((WildcardQueryBuilder)QueryBuilders.wildcardQuery((String)translatedFieldName, (String)query.value()).caseInsensitive(query.caseInsensitive()).rewrite(query.rewrite()).boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof MatchQueryBuilder) {
            MatchQueryBuilder query = (MatchQueryBuilder)queryBuilder;
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)translatedFieldName, (Object)query.value());
            if (query.operator() != null) {
                matchQueryBuilder.operator(query.operator());
            }
            if (query.analyzer() != null) {
                matchQueryBuilder.analyzer(query.analyzer());
            }
            if (query.fuzziness() != null) {
                matchQueryBuilder.fuzziness(query.fuzziness());
            }
            if (query.minimumShouldMatch() != null) {
                matchQueryBuilder.minimumShouldMatch(query.minimumShouldMatch());
            }
            if (query.fuzzyRewrite() != null) {
                matchQueryBuilder.fuzzyRewrite(query.fuzzyRewrite());
            }
            if (query.zeroTermsQuery() != null) {
                matchQueryBuilder.zeroTermsQuery(query.zeroTermsQuery());
            }
            ((MatchQueryBuilder)matchQueryBuilder.prefixLength(query.prefixLength()).maxExpansions(query.maxExpansions()).fuzzyTranspositions(query.fuzzyTranspositions()).lenient(query.lenient()).autoGenerateSynonymsPhraseQuery(query.autoGenerateSynonymsPhraseQuery()).boost(query.boost())).queryName(query.queryName());
            return matchQueryBuilder;
        }
        if (queryBuilder instanceof RangeQueryBuilder) {
            RangeQueryBuilder query = (RangeQueryBuilder)queryBuilder;
            if (query.relation() != null) {
                throw new IllegalArgumentException("range query with relation is not supported for API Key query");
            }
            String translatedFieldName = ApiKeyFieldNameTranslators.translate(query.fieldName());
            fieldNameVisitor.accept(translatedFieldName);
            RangeQueryBuilder newQuery = QueryBuilders.rangeQuery((String)translatedFieldName);
            if (query.format() != null) {
                newQuery.format(query.format());
            }
            if (query.timeZone() != null) {
                newQuery.timeZone(query.timeZone());
            }
            if (query.from() != null) {
                newQuery.from(query.from()).includeLower(query.includeLower());
            }
            if (query.to() != null) {
                newQuery.to(query.to()).includeUpper(query.includeUpper());
            }
            return ((RangeQueryBuilder)newQuery.boost(query.boost())).queryName(query.queryName());
        }
        if (queryBuilder instanceof SimpleQueryStringBuilder) {
            SimpleQueryStringBuilder query = (SimpleQueryStringBuilder)queryBuilder;
            SimpleQueryStringBuilder simpleQueryStringBuilder = QueryBuilders.simpleQueryStringQuery((String)query.value());
            HashMap<String, Float> queryFields = new HashMap<String, Float>(query.fields());
            if (queryFields.isEmpty()) {
                queryFields.put("*", Float.valueOf(1.0f));
            }
            if (QueryParserHelper.hasAllFieldsWildcard(queryFields.keySet())) {
                simpleQueryStringBuilder.lenient(true);
            } else {
                simpleQueryStringBuilder.lenient(query.lenient());
            }
            for (Map.Entry requestedFieldNameOrPattern : queryFields.entrySet()) {
                for (String translatedField : ApiKeyFieldNameTranslators.translatePattern((String)requestedFieldNameOrPattern.getKey())) {
                    simpleQueryStringBuilder.fields().compute(translatedField, (k, v) -> Float.valueOf(v == null ? ((Float)requestedFieldNameOrPattern.getValue()).floatValue() : v.floatValue() * ((Float)requestedFieldNameOrPattern.getValue()).floatValue()));
                    fieldNameVisitor.accept(translatedField);
                }
            }
            if (simpleQueryStringBuilder.fields().isEmpty()) {
                return ((MatchNoneQueryBuilder)new MatchNoneQueryBuilder().boost(simpleQueryStringBuilder.boost())).queryName(simpleQueryStringBuilder.queryName());
            }
            return ((SimpleQueryStringBuilder)simpleQueryStringBuilder.analyzer(query.analyzer()).defaultOperator(query.defaultOperator()).minimumShouldMatch(query.minimumShouldMatch()).flags(query.flags()).type(query.type()).quoteFieldSuffix(query.quoteFieldSuffix()).analyzeWildcard(query.analyzeWildcard()).autoGenerateSynonymsPhraseQuery(query.autoGenerateSynonymsPhraseQuery()).fuzzyTranspositions(query.fuzzyTranspositions()).fuzzyMaxExpansions(query.fuzzyMaxExpansions()).fuzzyPrefixLength(query.fuzzyPrefixLength()).boost(query.boost())).queryName(query.queryName());
        }
        throw new IllegalArgumentException("Query type [" + queryBuilder.getName() + "] is not supported for API Key query");
    }

    protected static String translate(String fieldName) {
        if (Regex.isSimpleMatchPattern((String)fieldName)) {
            throw new IllegalArgumentException("Field name pattern [" + fieldName + "] is not allowed for API Key query or aggregation");
        }
        for (FieldNameTranslator translator : FIELD_NAME_TRANSLATORS) {
            if (!translator.supports(fieldName)) continue;
            return translator.translate(fieldName);
        }
        throw new IllegalArgumentException("Field [" + fieldName + "] is not allowed for API Key query or aggregation");
    }

    private static Set<String> translatePattern(String fieldNameOrPattern) {
        HashSet<String> indexFieldNames = new HashSet<String>();
        for (FieldNameTranslator translator : FIELD_NAME_TRANSLATORS) {
            if (!translator.supports(fieldNameOrPattern)) continue;
            indexFieldNames.add(translator.translate(fieldNameOrPattern));
        }
        return indexFieldNames;
    }

    static abstract class FieldNameTranslator {
        private final Function<String, String> translationFunc;

        protected FieldNameTranslator(Function<String, String> translationFunc) {
            this.translationFunc = translationFunc;
        }

        String translate(String fieldName) {
            return this.translationFunc.apply(fieldName);
        }

        abstract boolean supports(String var1);
    }

    static class ExactFieldNameTranslator
    extends FieldNameTranslator {
        private final String name;

        ExactFieldNameTranslator(Function<String, String> translationFunc, String name) {
            super(translationFunc);
            this.name = name;
        }

        @Override
        public boolean supports(String fieldNameOrPattern) {
            if (Regex.isSimpleMatchPattern((String)fieldNameOrPattern)) {
                return Regex.simpleMatch((String)fieldNameOrPattern, (String)this.name);
            }
            return this.name.equals(fieldNameOrPattern);
        }
    }

    static class PrefixFieldNameTranslator
    extends FieldNameTranslator {
        private final String prefix;

        PrefixFieldNameTranslator(Function<String, String> translationFunc, String prefix) {
            super(translationFunc);
            this.prefix = prefix;
        }

        @Override
        boolean supports(String fieldNamePrefix) {
            if (Regex.isSimpleMatchPattern((String)fieldNamePrefix)) {
                return false;
            }
            return fieldNamePrefix.startsWith(this.prefix);
        }
    }
}

