/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.apikey;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequestBuilder;
import org.elasticsearch.xpack.core.security.action.apikey.CreateApiKeyRequestBuilderFactory;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.rest.action.apikey.ApiKeyBaseRestHandler;

@ServerlessScope(value=Scope.PUBLIC)
public final class RestCreateApiKeyAction
extends ApiKeyBaseRestHandler {
    private final CreateApiKeyRequestBuilderFactory builderFactory;

    public RestCreateApiKeyAction(Settings settings, XPackLicenseState licenseState, CreateApiKeyRequestBuilderFactory builderFactory) {
        super(settings, licenseState);
        this.builderFactory = builderFactory;
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_security/api_key"), new RestHandler.Route(RestRequest.Method.PUT, "/_security/api_key"));
    }

    public String getName() {
        return "xpack_security_create_api_key";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        CreateApiKeyRequestBuilder builder = this.builderFactory.create((Client)client, request.hasParam("pathRestricted")).source(request.requiredContent(), request.getXContentType());
        String refresh = request.param("refresh");
        if (refresh != null) {
            builder.setRefreshPolicy(WriteRequest.RefreshPolicy.parse((String)request.param("refresh")));
        } else {
            builder.setRefreshPolicy(ApiKeyService.defaultCreateDocRefreshPolicy(this.settings));
        }
        return channel -> builder.execute((ActionListener)new RestToXContentListener(channel));
    }
}

