/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.restriction;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.core.security.authz.restriction.Workflow;
import org.elasticsearch.xpack.core.security.authz.restriction.WorkflowResolver;

public class WorkflowService {
    private static final Logger logger = LogManager.getLogger(WorkflowService.class);
    private static final String WORKFLOW_HEADER = "_xpack_security_workflow";

    public static Workflow resolveWorkflowAndStoreInThreadContext(RestHandler restHandler, ThreadContext threadContext) {
        Workflow workflow = WorkflowService.resolveWorkflow(restHandler);
        if (workflow != null) {
            assert (threadContext.getHeader(WORKFLOW_HEADER) == null) : "thread context should not have workflow set. existing workflow [" + threadContext.getHeader("_xpack_security_workflow") + "]";
            threadContext.putHeader(WORKFLOW_HEADER, workflow.name());
        }
        return workflow;
    }

    public static String readWorkflowFromThreadContext(ThreadContext threadContext) {
        return threadContext.getHeader(WORKFLOW_HEADER);
    }

    private static Workflow resolveWorkflow(RestHandler restHandler) {
        String restHandlerName = WorkflowService.resolveRestHandlerName(restHandler);
        if (restHandlerName == null) {
            logger.trace(() -> Strings.format((String)"unable to resolve name of REST handler [%s]", (Object[])new Object[]{restHandler.getClass()}));
            return null;
        }
        Workflow workflow = WorkflowResolver.resolveWorkflowForRestHandler((String)restHandlerName);
        if (workflow != null) {
            logger.trace(() -> Strings.format((String)"resolved workflow [%s] for REST handler [%s]", (Object[])new Object[]{workflow.name(), restHandlerName}));
        }
        return workflow;
    }

    private static String resolveRestHandlerName(RestHandler restHandler) {
        if (restHandler instanceof BaseRestHandler) {
            BaseRestHandler baseRestHandler = (BaseRestHandler)restHandler;
            return baseRestHandler.getName();
        }
        return null;
    }
}

