/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.jwt;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.RotatableSecret;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtAuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtRealmSettings;
import org.elasticsearch.xpack.core.security.authc.jwt.JwtUtil;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.support.CacheIteratorHelper;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.jwt.JwtAuthenticator;
import org.elasticsearch.xpack.security.authc.support.ClaimParser;
import org.elasticsearch.xpack.security.authc.support.DelegatedAuthorizationSupport;
import org.elasticsearch.xpack.security.support.ReloadableSecurityComponent;

public class JwtRealm
extends Realm
implements CachingRealm,
ReloadableSecurityComponent,
Releasable {
    private static final String LATEST_MALFORMED_JWT = "_latest_malformed_jwt";
    private static final Logger logger = LogManager.getLogger(JwtRealm.class);
    public static final String HEADER_END_USER_AUTHENTICATION = "Authorization";
    public static final String HEADER_CLIENT_AUTHENTICATION = "ES-Client-Authentication";
    public static final String HEADER_END_USER_AUTHENTICATION_SCHEME = "Bearer";
    private final Cache<BytesArray, ExpiringUser> jwtCache;
    private final CacheIteratorHelper<BytesArray, ExpiringUser> jwtCacheHelper;
    private final UserRoleMapper userRoleMapper;
    private final Boolean populateUserMetadata;
    private final ClaimParser claimParserPrincipal;
    private final ClaimParser claimParserGroups;
    private final ClaimParser claimParserDn;
    private final ClaimParser claimParserMail;
    private final ClaimParser claimParserName;
    private final JwtRealmSettings.ClientAuthenticationType clientAuthenticationType;
    private final RotatableSecret clientAuthenticationSharedSecret;
    private final JwtAuthenticator jwtAuthenticator;
    private final TimeValue allowedClockSkew;
    DelegatedAuthorizationSupport delegatedAuthorizationSupport = null;

    public JwtRealm(RealmConfig realmConfig, SSLService sslService, UserRoleMapper userRoleMapper) throws SettingsException {
        super(realmConfig);
        this.userRoleMapper = userRoleMapper;
        this.userRoleMapper.clearRealmCacheOnChange((CachingRealm)this);
        this.allowedClockSkew = (TimeValue)realmConfig.getSetting(JwtRealmSettings.ALLOWED_CLOCK_SKEW);
        this.populateUserMetadata = (Boolean)realmConfig.getSetting(JwtRealmSettings.POPULATE_USER_METADATA);
        this.clientAuthenticationType = (JwtRealmSettings.ClientAuthenticationType)realmConfig.getSetting(JwtRealmSettings.CLIENT_AUTHENTICATION_TYPE);
        this.clientAuthenticationSharedSecret = new RotatableSecret((SecureString)realmConfig.getSetting(JwtRealmSettings.CLIENT_AUTHENTICATION_SHARED_SECRET));
        JwtUtil.validateClientAuthenticationSettings((String)RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHENTICATION_TYPE), (JwtRealmSettings.ClientAuthenticationType)this.clientAuthenticationType, (String)RealmSettings.getFullSettingKey((RealmConfig)realmConfig, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHENTICATION_SHARED_SECRET), (RotatableSecret)this.clientAuthenticationSharedSecret);
        TimeValue jwtCacheTtl = (TimeValue)realmConfig.getSetting(JwtRealmSettings.JWT_CACHE_TTL);
        int jwtCacheSize = (Integer)realmConfig.getSetting(JwtRealmSettings.JWT_CACHE_SIZE);
        if (jwtCacheTtl.getNanos() > 0L && jwtCacheSize > 0) {
            this.jwtCache = CacheBuilder.builder().setExpireAfterWrite(jwtCacheTtl).setMaximumWeight((long)jwtCacheSize).build();
            this.jwtCacheHelper = new CacheIteratorHelper(this.jwtCache);
        } else {
            this.jwtCache = null;
            this.jwtCacheHelper = null;
        }
        this.jwtAuthenticator = new JwtAuthenticator(realmConfig, sslService, this::expireAll);
        Map<String, String> fallbackClaimNames = this.jwtAuthenticator.getFallbackClaimNames();
        this.claimParserPrincipal = ClaimParser.forSetting(logger, JwtRealmSettings.CLAIMS_PRINCIPAL, fallbackClaimNames, realmConfig, true);
        this.claimParserGroups = ClaimParser.forSetting(logger, JwtRealmSettings.CLAIMS_GROUPS, fallbackClaimNames, realmConfig, false);
        this.claimParserDn = ClaimParser.forSetting(logger, JwtRealmSettings.CLAIMS_DN, fallbackClaimNames, realmConfig, false);
        this.claimParserMail = ClaimParser.forSetting(logger, JwtRealmSettings.CLAIMS_MAIL, fallbackClaimNames, realmConfig, false);
        this.claimParserName = ClaimParser.forSetting(logger, JwtRealmSettings.CLAIMS_NAME, fallbackClaimNames, realmConfig, false);
    }

    public void initialize(Iterable<Realm> allRealms, XPackLicenseState xpackLicenseState) {
        if (this.delegatedAuthorizationSupport != null) {
            throw new IllegalStateException("Realm " + this.name() + " has already been initialized");
        }
        this.delegatedAuthorizationSupport = new DelegatedAuthorizationSupport(allRealms, this.config, xpackLicenseState);
    }

    public void close() {
        this.jwtAuthenticator.close();
    }

    public void lookupUser(String username, ActionListener<User> listener) {
        this.ensureInitialized();
        listener.onResponse(null);
    }

    public void expire(String username) {
        this.ensureInitialized();
        if (this.isCacheEnabled()) {
            logger.trace("Expiring JWT cache entries for realm [{}] principal=[{}]", (Object)this.name(), (Object)username);
            this.jwtCacheHelper.removeValuesIf(expiringUser -> expiringUser.user.principal().equals(username));
            logger.trace("Expired JWT cache entries for realm [{}] principal=[{}]", (Object)this.name(), (Object)username);
        }
    }

    public void expireAll() {
        this.ensureInitialized();
        this.invalidateJwtCache();
    }

    public AuthenticationToken token(ThreadContext threadContext) {
        this.ensureInitialized();
        SecureString userCredentials = JwtUtil.getHeaderValue((ThreadContext)threadContext, (String)HEADER_END_USER_AUTHENTICATION, (String)HEADER_END_USER_AUTHENTICATION_SCHEME, (boolean)false);
        SignedJWT signedJWT = this.parseSignedJWT(userCredentials, threadContext);
        if (signedJWT == null) {
            return null;
        }
        SecureString clientCredentials = JwtUtil.getHeaderValue((ThreadContext)threadContext, (String)HEADER_CLIENT_AUTHENTICATION, (String)"SharedSecret", (boolean)true);
        return new JwtAuthenticationToken(signedJWT, JwtUtil.sha256((CharSequence)userCredentials), clientCredentials);
    }

    public boolean supports(AuthenticationToken jwtAuthenticationToken) {
        return jwtAuthenticationToken instanceof JwtAuthenticationToken;
    }

    public void authenticate(AuthenticationToken authenticationToken, ActionListener<AuthenticationResult<User>> listener) {
        this.ensureInitialized();
        if (authenticationToken instanceof JwtAuthenticationToken) {
            User cachedUser;
            BytesArray jwtCacheKey;
            JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authenticationToken;
            String tokenPrincipal = jwtAuthenticationToken.principal();
            SecureString clientSecret = jwtAuthenticationToken.getClientAuthenticationSharedSecret();
            try {
                JwtUtil.validateClientAuthentication((JwtRealmSettings.ClientAuthenticationType)this.clientAuthenticationType, (RotatableSecret)this.clientAuthenticationSharedSecret, (SecureString)clientSecret, (String)tokenPrincipal);
                logger.trace("Realm [{}] client authentication succeeded for token=[{}].", (Object)this.name(), (Object)tokenPrincipal);
            }
            catch (Exception e) {
                String msg = "Realm [" + this.name() + "] client authentication failed for token=[" + tokenPrincipal + "].";
                logger.debug(msg, (Throwable)e);
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, (Exception)e));
                return;
            }
            BytesArray bytesArray = jwtCacheKey = this.isCacheEnabled() ? new BytesArray(new BytesRef(jwtAuthenticationToken.getUserCredentialsHash()), true) : null;
            if (jwtCacheKey != null && (cachedUser = this.tryAuthenticateWithCache(tokenPrincipal, jwtCacheKey)) != null) {
                if (this.delegatedAuthorizationSupport.hasDelegation()) {
                    this.delegatedAuthorizationSupport.resolve(cachedUser.principal(), listener);
                } else {
                    listener.onResponse((Object)AuthenticationResult.success((Object)cachedUser));
                }
                return;
            }
            this.jwtAuthenticator.authenticate(jwtAuthenticationToken, (ActionListener<JWTClaimsSet>)ActionListener.wrap(claimsSet -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Realm [{}] JWT validation success for token=[{}] with header [{}] and claimSet [{}]", (Object)this.name(), (Object)tokenPrincipal, (Object)jwtAuthenticationToken.getSignedJWT().getHeader(), (Object)jwtAuthenticationToken.getJWTClaimsSet());
                }
                this.processValidatedJwt(tokenPrincipal, jwtCacheKey, (JWTClaimsSet)claimsSet, listener);
            }, ex -> {
                String msg = "Realm [" + this.name() + "] JWT validation failed for token=[" + tokenPrincipal + "] with header [" + jwtAuthenticationToken.getSignedJWT().getHeader() + "] and claimSet [" + jwtAuthenticationToken.getJWTClaimsSet() + "]";
                if (logger.isTraceEnabled()) {
                    logger.trace(msg, (Throwable)ex);
                } else {
                    logger.debug(msg + " Cause: " + ex.getMessage());
                }
                listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, (Exception)ex));
            }));
        } else {
            assert (false) : "should not happen";
            String className = authenticationToken == null ? "null" : authenticationToken.getClass().getCanonicalName();
            String msg = "Realm [" + this.name() + "] does not support AuthenticationToken [" + className + "].";
            logger.trace(msg);
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
        }
    }

    void ensureInitialized() {
        if (this.delegatedAuthorizationSupport == null) {
            throw new IllegalStateException("Realm has not been initialized");
        }
    }

    RealmConfig getConfig() {
        return this.config;
    }

    JwtAuthenticator getJwtAuthenticator() {
        return this.jwtAuthenticator;
    }

    private User tryAuthenticateWithCache(String tokenPrincipal, BytesArray jwtCacheKey) {
        ExpiringUser expiringUser = (ExpiringUser)this.jwtCache.get((Object)jwtCacheKey);
        if (expiringUser == null) {
            logger.trace("Realm [" + this.name() + "] JWT cache miss token=[" + tokenPrincipal + "] key=[" + jwtCacheKey + "].");
        } else {
            User user = expiringUser.user;
            Date exp = expiringUser.exp;
            String principal = user.principal();
            Date now = new Date();
            boolean cacheEntryNotExpired = now.getTime() < exp.getTime();
            logger.trace("Realm [{}] JWT cache {} token=[{}] key=[{}] principal=[{}] exp=[{}] now=[{}].", (Object)this.name(), (Object)(cacheEntryNotExpired ? "hit" : "exp"), (Object)tokenPrincipal, (Object)jwtCacheKey, (Object)principal, (Object)exp, (Object)now);
            if (cacheEntryNotExpired) {
                return user;
            }
        }
        return null;
    }

    void processValidatedJwt(String tokenPrincipal, BytesArray jwtCacheKey, JWTClaimsSet claimsSet, ActionListener<AuthenticationResult<User>> listener) {
        String principal = this.claimParserPrincipal.getClaimValue(claimsSet);
        if (!org.elasticsearch.common.Strings.hasText((String)principal)) {
            String msg = "Realm [" + this.name() + "] no principal for token=[" + tokenPrincipal + "] parser=[" + this.claimParserPrincipal + "] claims=[" + claimsSet + "].";
            logger.debug(msg);
            listener.onResponse((Object)AuthenticationResult.unsuccessful((String)msg, null));
            return;
        }
        ActionListener logAndCacheListener = ActionListener.wrap(result -> {
            if (result.isAuthenticated()) {
                User user = (User)result.getValue();
                logger.trace(() -> Strings.format((String)"Realm [%s] roles resolved [%s] for principal=[%s].", (Object[])new Object[]{this.name(), String.join((CharSequence)",", user.roles()), principal}));
                if (this.isCacheEnabled()) {
                    try (ReleasableLock ignored = this.jwtCacheHelper.acquireUpdateLock();){
                        long expWallClockMillis = claimsSet.getExpirationTime().getTime() + this.allowedClockSkew.getMillis();
                        this.jwtCache.put((Object)jwtCacheKey, (Object)new ExpiringUser((User)result.getValue(), new Date(expWallClockMillis)));
                    }
                }
            }
            listener.onResponse(result);
        }, arg_0 -> listener.onFailure(arg_0));
        if (this.delegatedAuthorizationSupport.hasDelegation()) {
            this.delegatedAuthorizationSupport.resolve(principal, (ActionListener<AuthenticationResult<User>>)logAndCacheListener);
            return;
        }
        Map<String, Object> userMetadata = this.buildUserMetadata(claimsSet);
        List<String> groups = this.claimParserGroups.getClaimValues(claimsSet);
        String dn = this.claimParserDn.getClaimValue(claimsSet);
        String mail = this.claimParserMail.getClaimValue(claimsSet);
        String name = this.claimParserName.getClaimValue(claimsSet);
        UserRoleMapper.UserData userData = new UserRoleMapper.UserData(principal, dn, groups, userMetadata, this.config);
        this.userRoleMapper.resolveRoles(userData, ActionListener.wrap(rolesSet -> {
            User user = new User(principal, rolesSet.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY), name, mail, userData.getMetadata(), true);
            logAndCacheListener.onResponse((Object)AuthenticationResult.success((Object)user));
        }, arg_0 -> ((ActionListener)logAndCacheListener).onFailure(arg_0)));
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        this.ensureInitialized();
        super.usageStats(ActionListener.wrap(stats -> {
            stats.put("jwt.cache", Collections.singletonMap("size", this.isCacheEnabled() ? this.jwtCache.count() : -1));
            listener.onResponse(stats);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void reload(Settings settings) {
        SecureString newClientSharedSecret = (SecureString)JwtRealmSettings.CLIENT_AUTHENTICATION_SHARED_SECRET.getConcreteSettingForNamespace(this.realmRef().getName()).get(settings);
        JwtUtil.validateClientAuthenticationSettings((String)RealmSettings.getFullSettingKey((RealmConfig)this.config, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHENTICATION_TYPE), (JwtRealmSettings.ClientAuthenticationType)this.clientAuthenticationType, (String)RealmSettings.getFullSettingKey((RealmConfig)this.config, (Setting.AffixSetting)JwtRealmSettings.CLIENT_AUTHENTICATION_SHARED_SECRET), (RotatableSecret)new RotatableSecret(newClientSharedSecret));
        this.clientAuthenticationSharedSecret.rotate(newClientSharedSecret, (TimeValue)this.config.getSetting(JwtRealmSettings.CLIENT_AUTH_SHARED_SECRET_ROTATION_GRACE_PERIOD));
    }

    private void invalidateJwtCache() {
        if (this.isCacheEnabled()) {
            try {
                logger.trace("Invalidating JWT cache for realm [{}]", (Object)this.name());
                try (ReleasableLock ignored = this.jwtCacheHelper.acquireForIterator();){
                    this.jwtCache.invalidateAll();
                }
                logger.debug("Invalidated JWT cache for realm [{}]", (Object)this.name());
            }
            catch (Exception e) {
                logger.warn("Exception invalidating JWT cache for realm [" + this.name() + "]", (Throwable)e);
            }
        }
    }

    private boolean isCacheEnabled() {
        return this.jwtCache != null && this.jwtCacheHelper != null;
    }

    Cache<BytesArray, ExpiringUser> getJwtCache() {
        return this.jwtCache;
    }

    private Map<String, Object> buildUserMetadata(JWTClaimsSet claimsSet) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("jwt_token_type", this.jwtAuthenticator.getTokenType().value());
        if (this.populateUserMetadata.booleanValue()) {
            claimsSet.getClaims().entrySet().stream().filter(entry -> JwtRealm.isAllowedTypeForClaim(entry.getValue())).forEach(entry -> metadata.put("jwt_claim_" + (String)entry.getKey(), (String)entry.getValue()));
        }
        return Map.copyOf(metadata);
    }

    private SignedJWT parseSignedJWT(SecureString token, ThreadContext threadContext) {
        if (Objects.equals(token, threadContext.getTransient(LATEST_MALFORMED_JWT))) {
            return null;
        }
        SignedJWT signedJWT = JwtUtil.parseSignedJWT((SecureString)token);
        if (signedJWT == null) {
            threadContext.putTransient(LATEST_MALFORMED_JWT, (Object)token);
        }
        return signedJWT;
    }

    private static boolean isAllowedTypeForClaim(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number || value instanceof Collection && ((Collection)value).stream().allMatch(e -> e instanceof String || e instanceof Boolean || e instanceof Number);
    }

    record ExpiringUser(User user, Date exp) {
        ExpiringUser {
            Objects.requireNonNull(user, "User must not be null");
            Objects.requireNonNull(exp, "Expiration date must not be null");
        }
    }
}

