/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.GetRolesRequest;
import org.elasticsearch.xpack.core.security.action.role.GetRolesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;

public class TransportGetRolesAction
extends TransportAction<GetRolesRequest, GetRolesResponse> {
    private final NativeRolesStore nativeRolesStore;
    private final ReservedRolesStore reservedRolesStore;

    @Inject
    public TransportGetRolesAction(ActionFilters actionFilters, NativeRolesStore nativeRolesStore, TransportService transportService, ReservedRolesStore reservedRolesStore) {
        super("cluster:admin/xpack/security/role/get", actionFilters, transportService.getTaskManager());
        this.nativeRolesStore = nativeRolesStore;
        this.reservedRolesStore = reservedRolesStore;
    }

    protected void doExecute(Task task, GetRolesRequest request, ActionListener<GetRolesResponse> listener) {
        boolean specificRolesRequested;
        String[] requestedRoles = request.names();
        boolean bl = specificRolesRequested = requestedRoles != null && requestedRoles.length > 0;
        if (request.nativeOnly()) {
            Set<String> rolesToSearchFor = specificRolesRequested ? Arrays.stream(requestedRoles).collect(Collectors.toSet()) : Collections.emptySet();
            this.getNativeRoles(rolesToSearchFor, listener);
            return;
        }
        HashSet<String> rolesToSearchFor = new HashSet<String>();
        ArrayList<RoleDescriptor> reservedRoles = new ArrayList<RoleDescriptor>();
        if (specificRolesRequested) {
            for (String role : requestedRoles) {
                if (ReservedRolesStore.isReserved((String)role)) {
                    RoleDescriptor rd = ReservedRolesStore.roleDescriptor((String)role);
                    if (rd != null) {
                        reservedRoles.add(rd);
                        continue;
                    }
                    listener.onFailure((Exception)new IllegalStateException("unable to obtain reserved role [" + role + "]"));
                    return;
                }
                rolesToSearchFor.add(role);
            }
        } else {
            reservedRoles.addAll(ReservedRolesStore.roleDescriptors());
        }
        if (specificRolesRequested && rolesToSearchFor.isEmpty()) {
            listener.onResponse((Object)new GetRolesResponse(reservedRoles.toArray(new RoleDescriptor[0])));
        } else {
            this.getNativeRoles(rolesToSearchFor, reservedRoles, listener);
        }
    }

    private void getNativeRoles(Set<String> rolesToSearchFor, ActionListener<GetRolesResponse> listener) {
        this.getNativeRoles(rolesToSearchFor, new ArrayList<RoleDescriptor>(), listener);
    }

    private void getNativeRoles(Set<String> rolesToSearchFor, List<RoleDescriptor> foundRoles, ActionListener<GetRolesResponse> listener) {
        this.nativeRolesStore.getRoleDescriptors(rolesToSearchFor, (ActionListener<RoleRetrievalResult>)ActionListener.wrap(retrievalResult -> {
            if (retrievalResult.isSuccess()) {
                foundRoles.addAll(retrievalResult.getDescriptors());
                listener.onResponse((Object)new GetRolesResponse(foundRoles.toArray(new RoleDescriptor[0])));
            } else {
                listener.onFailure(retrievalResult.getFailure());
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

