/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.List;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.apikey.BaseBulkUpdateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.BulkUpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.apikey.UpdateCrossClusterApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.action.apikey.TransportBaseUpdateApiKeyAction;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportUpdateCrossClusterApiKeyAction
extends TransportBaseUpdateApiKeyAction<UpdateCrossClusterApiKeyRequest, UpdateApiKeyResponse> {
    private final ApiKeyService apiKeyService;

    @Inject
    public TransportUpdateCrossClusterApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context) {
        super("cluster:admin/xpack/security/cross_cluster/api_key/update", transportService, actionFilters, context);
        this.apiKeyService = apiKeyService;
    }

    @Override
    void doExecuteUpdate(Task task, UpdateCrossClusterApiKeyRequest request, Authentication authentication, ActionListener<UpdateApiKeyResponse> listener) {
        this.apiKeyService.updateApiKeys(authentication, new BaseBulkUpdateApiKeyRequest(List.of(request.getId()), request.getRoleDescriptors(), request.getMetadata(), request.getExpiration()){

            public ApiKey.Type getType() {
                return ApiKey.Type.CROSS_CLUSTER;
            }
        }, Set.of(), (ActionListener<BulkUpdateApiKeyResponse>)ActionListener.wrap(bulkResponse -> listener.onResponse((Object)TransportUpdateCrossClusterApiKeyAction.toSingleResponse(request.getId(), bulkResponse)), arg_0 -> listener.onFailure(arg_0)));
    }
}

