/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.QueryApiKeyResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.profile.ProfileService;
import org.elasticsearch.xpack.security.support.ApiKeyAggregationsBuilder;
import org.elasticsearch.xpack.security.support.ApiKeyBoolQueryBuilder;
import org.elasticsearch.xpack.security.support.ApiKeyFieldNameTranslators;

public final class TransportQueryApiKeyAction
extends TransportAction<QueryApiKeyRequest, QueryApiKeyResponse> {
    public static final String API_KEY_TYPE_RUNTIME_MAPPING_FIELD = "runtime_key_type";
    private static final Map<String, Object> API_KEY_TYPE_RUNTIME_MAPPING = Map.of("runtime_key_type", Map.of("type", "keyword", "script", Map.of("source", "emit(field('type').get(\"rest\"));")));
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;
    private final ProfileService profileService;

    @Inject
    public TransportQueryApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, ProfileService profileService) {
        super("cluster:admin/xpack/security/api_key/query", actionFilters, transportService.getTaskManager());
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
        this.profileService = profileService;
    }

    protected void doExecute(Task task, QueryApiKeyRequest request, ActionListener<QueryApiKeyResponse> listener) {
        Authentication filteringAuthentication = this.securityContext.getAuthentication();
        if (filteringAuthentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
        }
        if (!request.isFilterForCurrentUser()) {
            filteringAuthentication = null;
        }
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().version(Boolean.valueOf(false)).fetchSource(true).trackTotalHits(true);
        if (request.getFrom() != null) {
            searchSourceBuilder.from(request.getFrom().intValue());
        }
        if (request.getSize() != null) {
            searchSourceBuilder.size(request.getSize().intValue());
        }
        AtomicBoolean accessesApiKeyTypeField = new AtomicBoolean(false);
        searchSourceBuilder.query((QueryBuilder)ApiKeyBoolQueryBuilder.build(request.getQueryBuilder(), fieldName -> {
            if (API_KEY_TYPE_RUNTIME_MAPPING_FIELD.equals(fieldName)) {
                accessesApiKeyTypeField.set(true);
            }
        }, filteringAuthentication));
        if (request.getFieldSortBuilders() != null) {
            ApiKeyFieldNameTranslators.translateFieldSortBuilders(request.getFieldSortBuilders(), searchSourceBuilder, fieldName -> {
                if (API_KEY_TYPE_RUNTIME_MAPPING_FIELD.equals(fieldName)) {
                    accessesApiKeyTypeField.set(true);
                }
            });
        }
        searchSourceBuilder.aggregationsBuilder(ApiKeyAggregationsBuilder.process(request.getAggsBuilder(), fieldName -> {
            if (API_KEY_TYPE_RUNTIME_MAPPING_FIELD.equals(fieldName)) {
                accessesApiKeyTypeField.set(true);
            }
        }));
        if (accessesApiKeyTypeField.get()) {
            searchSourceBuilder.runtimeMappings(API_KEY_TYPE_RUNTIME_MAPPING);
        }
        if (request.getSearchAfterBuilder() != null) {
            searchSourceBuilder.searchAfter(request.getSearchAfterBuilder().getSortValues());
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{".security"}, searchSourceBuilder);
        this.apiKeyService.queryApiKeys(searchRequest, request.withLimitedBy(), (ActionListener<ApiKeyService.QueryApiKeysResult>)ActionListener.wrap(queryApiKeysResult -> {
            if (request.withProfileUid()) {
                this.profileService.resolveProfileUidsForApiKeys(queryApiKeysResult.apiKeyInfos(), (ActionListener<Collection<String>>)ActionListener.wrap(ownerProfileUids -> listener.onResponse((Object)new QueryApiKeyResponse(queryApiKeysResult.total(), queryApiKeysResult.apiKeyInfos(), queryApiKeysResult.sortValues(), ownerProfileUids, queryApiKeysResult.aggregations())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)new QueryApiKeyResponse(queryApiKeysResult.total(), queryApiKeysResult.apiKeyInfos(), queryApiKeysResult.sortValues(), null, queryApiKeysResult.aggregations()));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

