/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.apikey;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.InvalidateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportInvalidateApiKeyAction
extends HandledTransportAction<InvalidateApiKeyRequest, InvalidateApiKeyResponse> {
    private final ApiKeyService apiKeyService;
    private final SecurityContext securityContext;
    private final Client client;

    @Inject
    public TransportInvalidateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService, SecurityContext context, Client client) {
        super("cluster:admin/xpack/security/api_key/invalidate", transportService, actionFilters, InvalidateApiKeyRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.apiKeyService = apiKeyService;
        this.securityContext = context;
        this.client = client;
    }

    protected void doExecute(Task task, InvalidateApiKeyRequest request, ActionListener<InvalidateApiKeyResponse> listener) {
        Authentication authentication = this.securityContext.getAuthentication();
        if (authentication == null) {
            listener.onFailure((Exception)new IllegalStateException("authentication is required"));
            return;
        }
        String[] apiKeyIds = request.getIds();
        String apiKeyName = request.getName();
        String username = this.getUsername(authentication, request);
        String[] realms = this.getRealms(authentication, request);
        this.checkHasManageSecurityPrivilege((ActionListener<HasPrivilegesResponse>)ActionListener.wrap(hasPrivilegesResponse -> this.apiKeyService.invalidateApiKeys(realms, username, apiKeyName, apiKeyIds, hasPrivilegesResponse.isCompleteMatch(), listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private String getUsername(Authentication authentication, InvalidateApiKeyRequest request) {
        if (request.ownedByAuthenticatedUser()) {
            assert (request.getUserName() == null);
            return authentication.getEffectiveSubject().getUser().principal();
        }
        return request.getUserName();
    }

    private String[] getRealms(Authentication authentication, InvalidateApiKeyRequest request) {
        String[] stringArray;
        if (request.ownedByAuthenticatedUser()) {
            assert (request.getRealmName() == null);
            return ApiKeyService.getOwnersRealmNames(authentication);
        }
        if (Strings.hasText((String)request.getRealmName())) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = request.getRealmName();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    private void checkHasManageSecurityPrivilege(ActionListener<HasPrivilegesResponse> listener) {
        HasPrivilegesRequest hasPrivilegesRequest = new HasPrivilegesRequest();
        hasPrivilegesRequest.username(this.securityContext.getUser().principal());
        hasPrivilegesRequest.clusterPrivileges(new String[]{ClusterPrivilegeResolver.MANAGE_SECURITY.name()});
        hasPrivilegesRequest.indexPrivileges(new RoleDescriptor.IndicesPrivileges[0]);
        hasPrivilegesRequest.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        this.client.execute((ActionType)HasPrivilegesAction.INSTANCE, (ActionRequest)hasPrivilegesRequest, ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }
}

