/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.stats;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.AbstractScriptFieldType;
import org.elasticsearch.index.mapper.ConstantFieldType;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocCountFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.ql.type.DataType;

public class SearchStats {
    private final List<SearchExecutionContext> contexts;
    private static final int CACHE_SIZE = 32;
    private final Map<String, FieldStat> cache = new LinkedHashMap<String, FieldStat>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, FieldStat> eldest) {
            return this.size() > 32;
        }
    };

    public SearchStats(List<SearchExecutionContext> contexts) {
        this.contexts = contexts;
    }

    public long count() {
        long[] count = new long[]{0L};
        boolean completed = this.doWithContexts(r -> {
            count[0] = count[0] + (long)r.numDocs();
            return true;
        }, false);
        return completed ? count[0] : -1L;
    }

    public long count(String field) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.count == null) {
            long[] count = new long[]{0L};
            boolean completed = this.doWithContexts(r -> {
                count[0] = count[0] + SearchStats.countEntries(r, field);
                return true;
            }, false);
            stat.count = completed ? count[0] : -1L;
        }
        return stat.count;
    }

    public long count(String field, BytesRef value) {
        long[] count = new long[]{0L};
        Term term = new Term(field, value);
        boolean completed = this.doWithContexts(r -> {
            count[0] = count[0] + (long)r.docFreq(term);
            return true;
        }, false);
        return completed ? count[0] : -1L;
    }

    public boolean exists(String field) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.exists == null) {
            stat.exists = false;
            for (SearchExecutionContext context : this.contexts) {
                if (!context.isFieldMapped(field)) continue;
                stat.exists = true;
                break;
            }
            if (!stat.exists.booleanValue()) {
                stat.indexed = false;
                stat.singleValue = true;
            }
        }
        return stat.exists;
    }

    public boolean hasIdenticalDelegate(String field) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.hasIdenticalDelegate == null) {
            stat.hasIdenticalDelegate = true;
            for (SearchExecutionContext context : this.contexts) {
                if (!context.isFieldMapped(field)) continue;
                MappedFieldType type = context.getFieldType(field);
                if (type instanceof TextFieldMapper.TextFieldType) {
                    TextFieldMapper.TextFieldType t = (TextFieldMapper.TextFieldType)type;
                    if (t.canUseSyntheticSourceDelegateForQuerying()) continue;
                    stat.hasIdenticalDelegate = false;
                    break;
                }
                stat.hasIdenticalDelegate = false;
                break;
            }
        }
        return stat.hasIdenticalDelegate;
    }

    public byte[] min(String field, DataType dataType) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.min == null) {
            byte[][] min = new byte[][]{null};
            this.doWithContexts(r -> {
                byte[] localMin = PointValues.getMinPackedValue((IndexReader)r, (String)field);
                if (localMin != null) {
                    if (min[0] == null) {
                        min[0] = localMin;
                    } else {
                        throw new EsqlIllegalArgumentException("Don't know how to compare with previous min");
                    }
                }
                return true;
            }, true);
            stat.min = min[0];
        }
        return null;
    }

    public byte[] max(String field, DataType dataType) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.max == null) {
            byte[][] max = new byte[][]{null};
            this.doWithContexts(r -> {
                byte[] localMax = PointValues.getMaxPackedValue((IndexReader)r, (String)field);
                if (localMax != null) {
                    if (max[0] == null) {
                        max[0] = localMax;
                    } else {
                        throw new EsqlIllegalArgumentException("Don't know how to compare with previous max");
                    }
                }
                return true;
            }, true);
            stat.max = max[0];
        }
        return null;
    }

    public boolean isSingleValue(String field) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.singleValue == null) {
            if (!this.exists(field)) {
                stat.singleValue = true;
            } else {
                boolean[] sv = new boolean[]{false};
                for (SearchExecutionContext context : this.contexts) {
                    MappedFieldType mappedType = context.isFieldMapped(field) ? context.getFieldType(field) : null;
                    if (mappedType == null) continue;
                    sv[0] = true;
                    this.doWithContexts(r -> {
                        sv[0] = sv[0] & this.detectSingleValue(r, mappedType, field);
                        return sv[0];
                    }, true);
                    break;
                }
                stat.singleValue = sv[0];
            }
        }
        return stat.singleValue;
    }

    public boolean isRuntimeField(String field) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.runtime == null) {
            stat.runtime = false;
            if (this.exists(field)) {
                for (SearchExecutionContext context : this.contexts) {
                    if (!context.isFieldMapped(field) || !(context.getFieldType(field) instanceof AbstractScriptFieldType)) continue;
                    stat.runtime = true;
                    break;
                }
            }
        }
        return stat.runtime;
    }

    public boolean isIndexed(String field) {
        FieldStat stat = this.cache.computeIfAbsent(field, s -> new FieldStat());
        if (stat.indexed == null) {
            stat.indexed = false;
            if (this.exists(field)) {
                boolean indexed = true;
                for (SearchExecutionContext context : this.contexts) {
                    if (!context.isFieldMapped(field) || context.getFieldType(field).isIndexed()) continue;
                    indexed = false;
                    break;
                }
                stat.indexed = indexed;
            }
        }
        return stat.indexed;
    }

    private boolean detectSingleValue(IndexReader r, MappedFieldType fieldType, String name) throws IOException {
        boolean found;
        String typeName;
        if (fieldType instanceof ConstantFieldType || fieldType instanceof DocCountFieldMapper.DocCountFieldType || fieldType instanceof DataStreamTimestampFieldMapper.TimestampFieldType) {
            return true;
        }
        switch (typeName = fieldType.typeName()) {
            case "_id": 
            case "_seq_no": {
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = found = false;
            }
        }
        if (found) {
            return true;
        }
        DocCountTester tester = null;
        if (fieldType instanceof DateFieldMapper.DateFieldType || fieldType instanceof NumberFieldMapper.NumberFieldType) {
            tester = lr -> {
                PointValues values = lr.getPointValues(name);
                return values == null || values.size() == (long)values.getDocCount();
            };
        } else if (fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
            tester = lr -> {
                Terms terms = lr.terms(name);
                return terms == null || terms.size() == (long)terms.getDocCount();
            };
        }
        if (tester != null) {
            for (LeafReaderContext context : r.leaves()) {
                if (tester.test(context.reader()).booleanValue()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static long countEntries(IndexReader indexReader, String field) {
        long count = 0L;
        try {
            for (LeafReaderContext context : indexReader.leaves()) {
                LeafReader reader = context.reader();
                FieldInfos fieldInfos = reader.getFieldInfos();
                FieldInfo fieldInfo = fieldInfos.fieldInfo(field);
                if (fieldInfo == null) continue;
                if (fieldInfo.getDocValuesType() == DocValuesType.NONE) {
                    return -1L;
                }
                if (fieldInfo.getPointIndexDimensionCount() > 0) {
                    PointValues points = reader.getPointValues(field);
                    if (points == null) continue;
                    count += points.size();
                    continue;
                }
                if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                    Terms terms = reader.terms(field);
                    if (terms == null) continue;
                    count += terms.getSumTotalTermFreq();
                    continue;
                }
                return -1L;
            }
        }
        catch (IOException ex) {
            throw new EsqlIllegalArgumentException("Cannot access data storage", ex);
        }
        return count;
    }

    private boolean doWithContexts(IndexReaderConsumer consumer, boolean acceptsDeletions) {
        try {
            for (SearchExecutionContext context : this.contexts) {
                for (LeafReaderContext leafContext : context.searcher().getLeafContexts()) {
                    LeafReader reader = leafContext.reader();
                    if (!acceptsDeletions && reader.hasDeletions()) {
                        return false;
                    }
                    if (consumer.consume((IndexReader)reader)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (IOException ex) {
            throw new EsqlIllegalArgumentException("Cannot access data storage", ex);
        }
    }

    private static interface IndexReaderConsumer {
        public boolean consume(IndexReader var1) throws IOException;
    }

    private static class FieldStat {
        private Long count;
        private Object min;
        private Object max;
        private Boolean exists;
        private Boolean singleValue;
        private Boolean hasIdenticalDelegate;
        private Boolean indexed;
        private Boolean runtime;

        private FieldStat() {
        }
    }

    private static interface DocCountTester {
        public Boolean test(LeafReader var1) throws IOException;
    }
}

