/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.io.IOException;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryAction;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;
import org.elasticsearch.xpack.esql.action.EsqlQueryTask;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolver;
import org.elasticsearch.xpack.esql.execution.PlanExecutor;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plugin.ComputeService;
import org.elasticsearch.xpack.esql.plugin.EsqlPlugin;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.async.AsyncTaskManagementService;

public class TransportEsqlQueryAction
extends HandledTransportAction<EsqlQueryRequest, EsqlQueryResponse>
implements AsyncTaskManagementService.AsyncOperation<EsqlQueryRequest, EsqlQueryResponse, EsqlQueryTask> {
    private final PlanExecutor planExecutor;
    private final ComputeService computeService;
    private final ExchangeService exchangeService;
    private final ClusterService clusterService;
    private final Executor requestExecutor;
    private final EnrichPolicyResolver enrichPolicyResolver;
    private final EnrichLookupService enrichLookupService;
    private final AsyncTaskManagementService<EsqlQueryRequest, EsqlQueryResponse, EsqlQueryTask> asyncTaskManagementService;

    @Inject
    public TransportEsqlQueryAction(TransportService transportService, ActionFilters actionFilters, PlanExecutor planExecutor, SearchService searchService, ExchangeService exchangeService, ClusterService clusterService, ThreadPool threadPool, BigArrays bigArrays, BlockFactory blockFactory, Client client, NamedWriteableRegistry registry) {
        super("indices:data/read/esql", transportService, actionFilters, EsqlQueryRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.planExecutor = planExecutor;
        this.clusterService = clusterService;
        this.requestExecutor = threadPool.executor("search");
        exchangeService.registerTransportHandler(transportService);
        this.exchangeService = exchangeService;
        this.enrichPolicyResolver = new EnrichPolicyResolver(clusterService, transportService, planExecutor.indexResolver());
        this.enrichLookupService = new EnrichLookupService(clusterService, searchService, transportService, bigArrays, blockFactory);
        this.computeService = new ComputeService(searchService, transportService, exchangeService, this.enrichLookupService, clusterService, threadPool, bigArrays, blockFactory);
        this.asyncTaskManagementService = new AsyncTaskManagementService(".async-search", client, "async_search", registry, this.taskManager, EsqlQueryAction.INSTANCE.name(), (AsyncTaskManagementService.AsyncOperation)this, EsqlQueryTask.class, clusterService, threadPool, bigArrays);
    }

    protected void doExecute(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        this.requestExecutor.execute((Runnable)ActionRunnable.wrap((ActionListener)listener.delegateFailureAndWrap(ActionListener::respondAndRelease), l -> this.doExecuteForked(task, request, (ActionListener<EsqlQueryResponse>)l)));
    }

    private void doExecuteForked(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search"}));
        if (TransportEsqlQueryAction.requestIsAsync(request)) {
            this.asyncTaskManagementService.asyncExecute((TaskAwareRequest)request, request.waitForCompletionTimeout(), request.keepAlive(), request.keepOnCompletion(), listener);
        } else {
            this.innerExecute(task, request, listener);
        }
    }

    public void execute(EsqlQueryRequest request, EsqlQueryTask task, ActionListener<EsqlQueryResponse> listener) {
        ActionListener.run(listener, l -> this.innerExecute((Task)task, request, (ActionListener<EsqlQueryResponse>)l));
    }

    private void innerExecute(Task task, EsqlQueryRequest request, ActionListener<EsqlQueryResponse> listener) {
        EsqlConfiguration configuration = new EsqlConfiguration(ZoneOffset.UTC, request.locale() != null ? request.locale() : Locale.US, null, this.clusterService.getClusterName().value(), request.pragmas(), (Integer)this.clusterService.getClusterSettings().get(EsqlPlugin.QUERY_RESULT_TRUNCATION_MAX_SIZE), (Integer)this.clusterService.getClusterSettings().get(EsqlPlugin.QUERY_RESULT_TRUNCATION_DEFAULT_SIZE), request.query(), request.profile());
        String sessionId = this.sessionID(task);
        this.planExecutor.esql(request, sessionId, configuration, this.enrichPolicyResolver, (ActionListener<PhysicalPlan>)listener.delegateFailureAndWrap((delegate, physicalPlan) -> this.computeService.execute(sessionId, (CancellableTask)task, (PhysicalPlan)((Object)physicalPlan), configuration, (ActionListener<ComputeService.Result>)delegate.map(result -> {
            EsqlQueryResponse.Profile profile;
            List<ColumnInfo> columns = physicalPlan.output().stream().map(c -> new ColumnInfo(c.qualifiedName(), EsqlDataTypes.outputType(c.dataType()))).toList();
            EsqlQueryResponse.Profile profile2 = profile = configuration.profile() ? new EsqlQueryResponse.Profile(result.profiles()) : null;
            if (task instanceof EsqlQueryTask) {
                EsqlQueryTask asyncTask = (EsqlQueryTask)task;
                if (request.keepOnCompletion()) {
                    String id = asyncTask.getExecutionId().getEncoded();
                    return new EsqlQueryResponse(columns, result.pages(), profile, request.columnar(), id, false, request.async());
                }
            }
            return new EsqlQueryResponse(columns, result.pages(), profile, request.columnar(), request.async());
        }))));
    }

    final String sessionID(Task task) {
        return new TaskId(this.clusterService.localNode().getId(), task.getId()).toString();
    }

    public ExchangeService exchangeService() {
        return this.exchangeService;
    }

    public EnrichLookupService enrichLookupService() {
        return this.enrichLookupService;
    }

    public EsqlQueryTask createTask(EsqlQueryRequest request, long id, String type, String action, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, AsyncExecutionId asyncExecutionId) {
        return new EsqlQueryTask(id, type, action, request.getDescription(), parentTaskId, headers, originHeaders, asyncExecutionId, request.keepAlive());
    }

    public EsqlQueryResponse initialResponse(EsqlQueryTask task) {
        return new EsqlQueryResponse(List.of(), List.of(), null, false, task.getExecutionId().getEncoded(), true, true);
    }

    public EsqlQueryResponse readResponse(StreamInput inputStream) throws IOException {
        throw new AssertionError((Object)"should not reach here");
    }

    private static boolean requestIsAsync(EsqlQueryRequest request) {
        return request.async();
    }
}

