/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.xcontent.MediaType;
import org.elasticsearch.xcontent.MediaTypeRegistry;
import org.elasticsearch.xcontent.ParsedMediaType;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.esql.action.EsqlQueryRequest;
import org.elasticsearch.xpack.esql.formatter.TextFormat;

public class EsqlMediaTypeParser {
    public static final MediaTypeRegistry<? extends MediaType> MEDIA_TYPE_REGISTRY = new MediaTypeRegistry().register((MediaType[])XContentType.values()).register((MediaType[])TextFormat.values());

    public static MediaType getResponseMediaType(RestRequest request, EsqlQueryRequest esqlRequest) {
        MediaType mediaType = request.hasParam("format") ? EsqlMediaTypeParser.mediaTypeFromParams(request) : EsqlMediaTypeParser.mediaTypeFromHeaders(request);
        return EsqlMediaTypeParser.validateColumnarRequest(esqlRequest.columnar(), mediaType, request);
    }

    private static MediaType mediaTypeFromHeaders(RestRequest request) {
        ParsedMediaType acceptType = request.getParsedAccept();
        XContentType mediaType = acceptType != null ? acceptType.toMediaType(MEDIA_TYPE_REGISTRY) : request.getXContentType();
        return EsqlMediaTypeParser.checkNonNullMediaType((MediaType)mediaType, request);
    }

    private static MediaType mediaTypeFromParams(RestRequest request) {
        return MEDIA_TYPE_REGISTRY.queryParamToMediaType(request.param("format"));
    }

    private static MediaType validateColumnarRequest(boolean requestIsColumnar, MediaType fromMediaType, RestRequest request) {
        if (requestIsColumnar && fromMediaType instanceof TextFormat) {
            throw new IllegalArgumentException("Invalid use of [columnar] argument: cannot be used in combination with " + Arrays.stream(TextFormat.values()).map(MediaType::queryParameter).toList() + " formats");
        }
        return EsqlMediaTypeParser.checkNonNullMediaType(fromMediaType, request);
    }

    private static MediaType checkNonNullMediaType(MediaType mediaType, RestRequest request) {
        if (mediaType == null) {
            String msg = String.format(Locale.ROOT, "Invalid request content type: Accept=[%s], Content-Type=[%s], format=[%s]", request.header("Accept"), request.header("Content-Type"), request.param("format"));
            throw new IllegalArgumentException(msg);
        }
        return mediaType;
    }
}

