/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardsGroup;
import org.elasticsearch.action.search.SearchShardsRequest;
import org.elasticsearch.action.search.SearchShardsResponse;
import org.elasticsearch.action.search.TransportSearchShardsAction;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.RefCountingListener;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverProfile;
import org.elasticsearch.compute.operator.DriverTaskRunner;
import org.elasticsearch.compute.operator.ResponseHeadersCollector;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.enrich.EnrichLookupService;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.OutputExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.planner.EsPhysicalOperationProviders;
import org.elasticsearch.xpack.esql.planner.LocalExecutionPlanner;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.plugin.ClusterComputeRequest;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.DataNodeRequest;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;

public class ComputeService {
    private static final Logger LOGGER = LogManager.getLogger(ComputeService.class);
    private final SearchService searchService;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final TransportService transportService;
    private final Executor esqlExecutor;
    private final DriverTaskRunner driverRunner;
    private final ExchangeService exchangeService;
    private final EnrichLookupService enrichLookupService;
    private final ClusterService clusterService;
    public static final String DATA_ACTION_NAME = "indices:data/read/esql/data";
    public static final String CLUSTER_ACTION_NAME = "indices:data/read/esql/cluster";

    public ComputeService(SearchService searchService, TransportService transportService, ExchangeService exchangeService, EnrichLookupService enrichLookupService, ClusterService clusterService, ThreadPool threadPool, BigArrays bigArrays, BlockFactory blockFactory) {
        this.searchService = searchService;
        this.transportService = transportService;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.blockFactory = blockFactory;
        this.esqlExecutor = threadPool.executor("search");
        transportService.registerRequestHandler(DATA_ACTION_NAME, this.esqlExecutor, DataNodeRequest::new, (TransportRequestHandler)new DataNodeRequestHandler());
        transportService.registerRequestHandler(CLUSTER_ACTION_NAME, this.esqlExecutor, ClusterComputeRequest::new, (TransportRequestHandler)new ClusterRequestHandler());
        this.driverRunner = new DriverTaskRunner(transportService, this.esqlExecutor);
        this.exchangeService = exchangeService;
        this.enrichLookupService = enrichLookupService;
        this.clusterService = clusterService;
    }

    public void execute(String sessionId, CancellableTask rootTask, PhysicalPlan physicalPlan, EsqlConfiguration configuration, ActionListener<Result> listener) {
        Tuple<PhysicalPlan, PhysicalPlan> coordinatorAndDataNodePlan = PlannerUtils.breakPlanBetweenCoordinatorAndDataNode(physicalPlan, configuration);
        List collectedPages = Collections.synchronizedList(new ArrayList());
        listener = listener.delegateResponse((l, e) -> {
            collectedPages.forEach(p -> Releasables.closeExpectNoException(() -> ((Page)p).releaseBlocks()));
            l.onFailure(e);
        });
        OutputExec coordinatorPlan = new OutputExec((PhysicalPlan)((Object)coordinatorAndDataNodePlan.v1()), collectedPages::add);
        PhysicalPlan dataNodePlan = (PhysicalPlan)((Object)coordinatorAndDataNodePlan.v2());
        if (dataNodePlan != null && !(dataNodePlan instanceof ExchangeSinkExec)) {
            assert (false) : "expected data node plan starts with an ExchangeSink; got " + dataNodePlan;
            listener.onFailure((Exception)new IllegalStateException("expected data node plan starts with an ExchangeSink; got " + dataNodePlan));
            return;
        }
        Map clusterToConcreteIndices = this.transportService.getRemoteClusterService().groupIndices(SearchRequest.DEFAULT_INDICES_OPTIONS, (String[])PlannerUtils.planConcreteIndices(physicalPlan).toArray(String[]::new));
        QueryPragmas queryPragmas = configuration.pragmas();
        if (dataNodePlan == null) {
            if (!clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
                String error = "expected no concrete indices without data node plan; got " + clusterToConcreteIndices;
                assert (false) : error;
                listener.onFailure((Exception)new IllegalStateException(error));
                return;
            }
            ComputeContext computeContext = new ComputeContext(sessionId, "", List.of(), configuration, null, null);
            this.runCompute(rootTask, computeContext, coordinatorPlan, (ActionListener<List<DriverProfile>>)listener.map(driverProfiles -> new Result(collectedPages, (List<DriverProfile>)driverProfiles)));
            return;
        }
        if (clusterToConcreteIndices.values().stream().allMatch(v -> v.indices().length == 0)) {
            String error = "expected concrete indices with data node plan but got empty; data node plan " + dataNodePlan;
            assert (false) : error;
            listener.onFailure((Exception)new IllegalStateException(error));
            return;
        }
        Map clusterToOriginalIndices = this.transportService.getRemoteClusterService().groupIndices(SearchRequest.DEFAULT_INDICES_OPTIONS, PlannerUtils.planOriginalIndices(physicalPlan));
        OriginalIndices localOriginalIndices = (OriginalIndices)clusterToOriginalIndices.remove("");
        OriginalIndices localConcreteIndices = (OriginalIndices)clusterToConcreteIndices.remove("");
        ResponseHeadersCollector responseHeadersCollector = new ResponseHeadersCollector(this.transportService.getThreadPool().getThreadContext());
        listener = ActionListener.runBefore((ActionListener)listener, () -> ((ResponseHeadersCollector)responseHeadersCollector).finish());
        AtomicBoolean cancelled = new AtomicBoolean();
        List collectedProfiles = configuration.profile() ? Collections.synchronizedList(new ArrayList()) : List.of();
        ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(queryPragmas.exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
        try (Releasable ignored = exchangeSource.addEmptySink();
             RefCountingListener refs = new RefCountingListener(listener.map(unused -> new Result(collectedPages, collectedProfiles)));){
            exchangeSource.addCompletionListener(refs.acquire());
            this.runCompute(rootTask, new ComputeContext(sessionId, "", List.of(), configuration, exchangeSource, null), coordinatorPlan, (ActionListener<List<DriverProfile>>)this.cancelOnFailure(rootTask, cancelled, (ActionListener<Void>)refs.acquire()).map(driverProfiles -> {
                responseHeadersCollector.collect();
                if (configuration.profile()) {
                    collectedProfiles.addAll(driverProfiles);
                }
                return null;
            }));
            if (localConcreteIndices != null && localConcreteIndices.indices().length > 0) {
                this.startComputeOnDataNodes(sessionId, "", rootTask, configuration, dataNodePlan, Set.of(localConcreteIndices.indices()), localOriginalIndices.indices(), exchangeSource, (ActionListener<Void>)ActionListener.releaseAfter((ActionListener)refs.acquire(), (Releasable)exchangeSource.addEmptySink()), () -> this.cancelOnFailure(rootTask, cancelled, (ActionListener<Void>)refs.acquire()).map(response -> {
                    responseHeadersCollector.collect();
                    if (configuration.profile()) {
                        collectedProfiles.addAll(response.getProfiles());
                    }
                    return null;
                }));
            }
            this.startComputeOnRemoteClusters(sessionId, rootTask, configuration, dataNodePlan, exchangeSource, this.getRemoteClusters(clusterToConcreteIndices, clusterToOriginalIndices), () -> this.cancelOnFailure(rootTask, cancelled, (ActionListener<Void>)refs.acquire()).map(response -> {
                responseHeadersCollector.collect();
                if (configuration.profile()) {
                    collectedProfiles.addAll(response.getProfiles());
                }
                return null;
            }));
        }
    }

    private List<RemoteCluster> getRemoteClusters(Map<String, OriginalIndices> clusterToConcreteIndices, Map<String, OriginalIndices> clusterToOriginalIndices) {
        ArrayList<RemoteCluster> remoteClusters = new ArrayList<RemoteCluster>(clusterToConcreteIndices.size());
        RemoteClusterService remoteClusterService = this.transportService.getRemoteClusterService();
        for (Map.Entry<String, OriginalIndices> e : clusterToConcreteIndices.entrySet()) {
            String clusterAlias = e.getKey();
            OriginalIndices concreteIndices = clusterToConcreteIndices.get(clusterAlias);
            OriginalIndices originalIndices = clusterToOriginalIndices.get(clusterAlias);
            if (originalIndices == null) {
                assert (false) : "can't find original indices for cluster " + clusterAlias;
                throw new IllegalStateException("can't find original indices for cluster " + clusterAlias);
            }
            if (concreteIndices.indices().length <= 0) continue;
            Transport.Connection connection = remoteClusterService.getConnection(clusterAlias);
            remoteClusters.add(new RemoteCluster(clusterAlias, connection, concreteIndices.indices(), originalIndices.indices()));
        }
        return remoteClusters;
    }

    private void startComputeOnDataNodes(String sessionId, String clusterAlias, CancellableTask parentTask, EsqlConfiguration configuration, PhysicalPlan dataNodePlan, Set<String> concreteIndices, String[] originalIndices, ExchangeSourceHandler exchangeSource, ActionListener<Void> parentListener, Supplier<ActionListener<ComputeResponse>> dataNodeListenerSupplier) {
        PhysicalPlan planWithReducer = !configuration.pragmas().nodeLevelReduction() ? dataNodePlan : (PhysicalPlan)dataNodePlan.transformUp(FragmentExec.class, f -> {
            PhysicalPlan reductionNode = PlannerUtils.dataNodeReductionPlan(f.fragment(), dataNodePlan);
            return reductionNode == null ? f : f.withReducer(reductionNode);
        });
        QueryBuilder requestFilter = PlannerUtils.requestFilter(planWithReducer, x -> true);
        this.lookupDataNodes((Task)parentTask, clusterAlias, requestFilter, concreteIndices, originalIndices, (ActionListener<List<DataNode>>)ActionListener.wrap(dataNodes -> {
            try (RefCountingRunnable refs = new RefCountingRunnable(() -> parentListener.onResponse(null));){
                for (DataNode node : dataNodes) {
                    ActionListener dataNodeListener = ActionListener.releaseAfter((ActionListener)((ActionListener)dataNodeListenerSupplier.get()), (Releasable)refs.acquire());
                    QueryPragmas queryPragmas = configuration.pragmas();
                    ExchangeService.openExchange((TransportService)this.transportService, (Transport.Connection)node.connection, (String)sessionId, (int)queryPragmas.exchangeBufferSize(), (Executor)this.esqlExecutor, (ActionListener)dataNodeListener.delegateFailureAndWrap((delegate, unused) -> {
                        RemoteSink remoteSink = this.exchangeService.newRemoteSink((Task)parentTask, sessionId, this.transportService, node.connection);
                        exchangeSource.addRemoteSink(remoteSink, queryPragmas.concurrentExchangeClients());
                        this.transportService.sendChildRequest(node.connection, DATA_ACTION_NAME, (TransportRequest)new DataNodeRequest(sessionId, configuration, clusterAlias, node.shardIds, node.aliasFilters, planWithReducer), (Task)parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(delegate, ComputeResponse::new, this.esqlExecutor));
                    }));
                }
            }
        }, arg_0 -> parentListener.onFailure(arg_0)));
    }

    private void startComputeOnRemoteClusters(String sessionId, CancellableTask rootTask, EsqlConfiguration configuration, PhysicalPlan plan, ExchangeSourceHandler exchangeSource, List<RemoteCluster> clusters, Supplier<ActionListener<ComputeResponse>> listener) {
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> ((Releasable)exchangeSource.addEmptySink()).close());){
            for (RemoteCluster cluster : clusters) {
                ActionListener targetNodeListener = ActionListener.releaseAfter(listener.get(), (Releasable)refs.acquire());
                QueryPragmas queryPragmas = configuration.pragmas();
                ExchangeService.openExchange((TransportService)this.transportService, (Transport.Connection)cluster.connection, (String)sessionId, (int)queryPragmas.exchangeBufferSize(), (Executor)this.esqlExecutor, (ActionListener)targetNodeListener.delegateFailureAndWrap((l, unused) -> {
                    RemoteSink remoteSink = this.exchangeService.newRemoteSink((Task)rootTask, sessionId, this.transportService, cluster.connection);
                    exchangeSource.addRemoteSink(remoteSink, queryPragmas.concurrentExchangeClients());
                    ClusterComputeRequest clusterRequest = new ClusterComputeRequest(cluster.clusterAlias, sessionId, configuration, plan, cluster.concreteIndices, cluster.originalIndices);
                    this.transportService.sendChildRequest(cluster.connection, CLUSTER_ACTION_NAME, (TransportRequest)clusterRequest, (Task)rootTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(l, ComputeResponse::new, this.esqlExecutor));
                }));
            }
        }
    }

    private ActionListener<Void> cancelOnFailure(CancellableTask task, AtomicBoolean cancelled, ActionListener<Void> listener) {
        return listener.delegateResponse((l, e) -> {
            l.onFailure(e);
            if (cancelled.compareAndSet(false, true)) {
                LOGGER.debug("cancelling ESQL task {} on failure", new Object[]{task});
                this.transportService.getTaskManager().cancelTaskAndDescendants(task, "cancelled", false, ActionListener.noop());
            }
        });
    }

    void runCompute(CancellableTask task, ComputeContext context, PhysicalPlan plan, ActionListener<List<DriverProfile>> listener) {
        List<Driver> drivers;
        listener = ActionListener.runBefore(listener, () -> Releasables.close(context.searchContexts));
        ArrayList<EsPhysicalOperationProviders.ShardContext> contexts = new ArrayList<EsPhysicalOperationProviders.ShardContext>(context.searchContexts.size());
        for (int i = 0; i < context.searchContexts.size(); ++i) {
            SearchContext searchContext = context.searchContexts.get(i);
            contexts.add(new EsPhysicalOperationProviders.DefaultShardContext(i, searchContext.getSearchExecutionContext(), searchContext.request().getAliasFilter()));
        }
        try {
            LocalExecutionPlanner planner = new LocalExecutionPlanner(context.sessionId, context.clusterAlias, task, this.bigArrays, this.blockFactory, this.clusterService.getSettings(), context.configuration, context.exchangeSource(), context.exchangeSink(), this.enrichLookupService, new EsPhysicalOperationProviders(contexts));
            LOGGER.debug("Received physical plan:\n{}", new Object[]{plan});
            plan = PlannerUtils.localPlan(context.searchExecutionContexts(), context.configuration, plan);
            LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan = planner.plan(plan);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Local execution plan:\n{}", new Object[]{localExecutionPlan.describe()});
            }
            if ((drivers = localExecutionPlan.createDrivers(context.sessionId)).isEmpty()) {
                throw new IllegalStateException("no drivers created");
            }
            LOGGER.debug("using {} drivers", new Object[]{drivers.size()});
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        ActionListener listenerCollectingStatus = listener.map(ignored -> {
            if (context.configuration.profile()) {
                return drivers.stream().map(Driver::profile).toList();
            }
            return null;
        });
        listenerCollectingStatus = ActionListener.releaseAfter((ActionListener)listenerCollectingStatus, () -> Releasables.close((Iterable)drivers));
        this.driverRunner.executeDrivers((Task)task, drivers, (Executor)this.transportService.getThreadPool().executor("esql_worker"), listenerCollectingStatus);
    }

    private void acquireSearchContexts(String clusterAlias, List<ShardId> shardIds, EsqlConfiguration configuration, Map<Index, AliasFilter> aliasFilters, ActionListener<List<SearchContext>> listener) {
        ArrayList<IndexShard> targetShards = new ArrayList<IndexShard>();
        try {
            for (ShardId shardId : shardIds) {
                IndexShard indexShard = this.searchService.getIndicesService().indexServiceSafe(shardId.getIndex()).getShard(shardId.id());
                targetShards.add(indexShard);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        ActionRunnable doAcquire = ActionRunnable.supply(listener, () -> {
            ArrayList<SearchContext> searchContexts = new ArrayList<SearchContext>(targetShards.size());
            boolean success = false;
            try {
                for (IndexShard shard : targetShards) {
                    AliasFilter aliasFilter = aliasFilters.getOrDefault(shard.shardId().getIndex(), AliasFilter.EMPTY);
                    ShardSearchRequest shardRequest = new ShardSearchRequest(shard.shardId(), configuration.absoluteStartedTimeInMillis(), aliasFilter, clusterAlias);
                    SearchContext context = this.searchService.createSearchContext(shardRequest, SearchService.NO_TIMEOUT);
                    searchContexts.add(context);
                }
                for (SearchContext searchContext : searchContexts) {
                    searchContext.preProcess();
                }
                success = true;
                ArrayList<SearchContext> arrayList = searchContexts;
                return arrayList;
            }
            finally {
                if (!success) {
                    IOUtils.close(searchContexts);
                }
            }
        });
        AtomicBoolean waitedForRefreshes = new AtomicBoolean();
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            if (waitedForRefreshes.get()) {
                this.esqlExecutor.execute((Runnable)doAcquire);
            } else {
                doAcquire.run();
            }
        });){
            for (IndexShard targetShard : targetShards) {
                Releasable ref = refs.acquire();
                targetShard.ensureShardSearchActive(await -> {
                    try (Releasable releasable = ref;){
                        if (await.booleanValue()) {
                            waitedForRefreshes.set(true);
                        }
                    }
                });
            }
        }
    }

    private void lookupDataNodes(Task parentTask, String clusterAlias, QueryBuilder filter, Set<String> concreteIndices, String[] originalIndices, ActionListener<List<DataNode>> listener) {
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        ContextPreservingActionListener preservingContextListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)listener.map(resp -> {
            HashMap<String, DiscoveryNode> nodes = new HashMap<String, DiscoveryNode>();
            for (DiscoveryNode node : resp.getNodes()) {
                nodes.put(node.getId(), node);
            }
            HashMap<String, List> nodeToShards = new HashMap<String, List>();
            HashMap nodeToAliasFilters = new HashMap();
            for (SearchShardsGroup group : resp.getGroups()) {
                ShardId shardId = group.shardId();
                if (group.skipped()) continue;
                if (group.allocatedNodes().isEmpty()) {
                    throw new ShardNotFoundException(group.shardId(), "no shard copies found {}", new Object[]{group.shardId()});
                }
                if (!concreteIndices.contains(shardId.getIndexName())) continue;
                String targetNode = (String)group.allocatedNodes().get(0);
                nodeToShards.computeIfAbsent(targetNode, k -> new ArrayList()).add(shardId);
                AliasFilter aliasFilter = (AliasFilter)resp.getAliasFilters().get(shardId.getIndex().getUUID());
                if (aliasFilter == null) continue;
                nodeToAliasFilters.computeIfAbsent(targetNode, k -> new HashMap()).put(shardId.getIndex(), aliasFilter);
            }
            ArrayList<DataNode> dataNodes = new ArrayList<DataNode>(nodeToShards.size());
            for (Map.Entry e : nodeToShards.entrySet()) {
                DiscoveryNode node = (DiscoveryNode)nodes.get(e.getKey());
                Map<Index, AliasFilter> aliasFilters = nodeToAliasFilters.getOrDefault(e.getKey(), Map.of());
                dataNodes.add(new DataNode(this.transportService.getConnection(node), (List)e.getValue(), aliasFilters));
            }
            return dataNodes;
        }), (ThreadContext)threadContext);
        try (ThreadContext.StoredContext ignored = threadContext.newStoredContextPreservingResponseHeaders();){
            threadContext.markAsSystemContext();
            SearchShardsRequest searchShardsRequest = new SearchShardsRequest(originalIndices, SearchRequest.DEFAULT_INDICES_OPTIONS, filter, null, null, false, clusterAlias);
            this.transportService.sendChildRequest(this.transportService.getLocalNode(), TransportSearchShardsAction.TYPE.name(), (TransportRequest)searchShardsRequest, parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)preservingContextListener, SearchShardsResponse::new, this.esqlExecutor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runComputeOnDataNode(CancellableTask task, String externalId, PhysicalPlan reducePlan, DataNodeRequest request, ActionListener<ComputeResponse> listener) {
        List<DriverProfile> collectedProfiles = request.configuration().profile() ? Collections.synchronizedList(new ArrayList()) : List.of();
        ResponseHeadersCollector responseHeadersCollector = new ResponseHeadersCollector(this.transportService.getThreadPool().getThreadContext());
        try (RefCountingListener listenerRefs = new RefCountingListener(ActionListener.runBefore((ActionListener)listener.map(unused -> new ComputeResponse(collectedProfiles)), () -> ((ResponseHeadersCollector)responseHeadersCollector).finish()));){
            AtomicBoolean cancelled = new AtomicBoolean();
            ExchangeSinkHandler internalSink = this.exchangeService.createSinkHandler(request.sessionId(), request.pragmas().exchangeBufferSize());
            DataNodeRequestExecutor dataNodeRequestExecutor = new DataNodeRequestExecutor(request, task, internalSink, request.configuration().pragmas().maxConcurrentShardsPerNode(), collectedProfiles, (ActionListener<Void>)ActionListener.runBefore(this.cancelOnFailure(task, cancelled, (ActionListener<Void>)listenerRefs.acquire()), () -> ((ResponseHeadersCollector)responseHeadersCollector).collect()));
            dataNodeRequestExecutor.start();
            ExchangeSinkHandler externalSink = this.exchangeService.getSinkHandler(externalId);
            task.addListener(() -> this.exchangeService.finishSinkHandler(externalId, (Exception)new TaskCancelledException(task.getReasonCancelled())));
            ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(1, this.esqlExecutor);
            exchangeSource.addCompletionListener(listenerRefs.acquire());
            exchangeSource.addRemoteSink((arg_0, arg_1) -> ((ExchangeSinkHandler)internalSink).fetchPageAsync(arg_0, arg_1), 1);
            ActionListener<Void> reductionListener = this.cancelOnFailure(task, cancelled, (ActionListener<Void>)listenerRefs.acquire());
            this.runCompute(task, new ComputeContext(request.sessionId(), request.clusterAlias(), List.of(), request.configuration(), exchangeSource, externalSink), reducePlan, (ActionListener<List<DriverProfile>>)ActionListener.wrap(driverProfiles -> {
                responseHeadersCollector.collect();
                if (request.configuration().profile()) {
                    collectedProfiles.addAll((Collection<DriverProfile>)driverProfiles);
                }
                externalSink.addCompletionListener(ActionListener.runBefore((ActionListener)reductionListener, () -> this.exchangeService.finishSinkHandler(externalId, null)));
            }, e -> {
                this.exchangeService.finishSinkHandler(externalId, e);
                reductionListener.onFailure(e);
            }));
        }
    }

    void runComputeOnRemoteCluster(String clusterAlias, String globalSessionId, CancellableTask parentTask, EsqlConfiguration configuration, ExchangeSinkExec plan, Set<String> concreteIndices, String[] originalIndices, ActionListener<ComputeResponse> listener) {
        ExchangeSinkHandler exchangeSink = this.exchangeService.getSinkHandler(globalSessionId);
        parentTask.addListener(() -> this.exchangeService.finishSinkHandler(globalSessionId, (Exception)new TaskCancelledException(parentTask.getReasonCancelled())));
        ThreadPool threadPool = this.transportService.getThreadPool();
        ResponseHeadersCollector responseHeadersCollector = new ResponseHeadersCollector(threadPool.getThreadContext());
        listener = ActionListener.runBefore(listener, () -> ((ResponseHeadersCollector)responseHeadersCollector).finish());
        AtomicBoolean cancelled = new AtomicBoolean();
        List collectedProfiles = configuration.profile() ? Collections.synchronizedList(new ArrayList()) : List.of();
        String localSessionId = clusterAlias + ":" + globalSessionId;
        ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(configuration.pragmas().exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
        try (Releasable ignored = exchangeSource.addEmptySink();
             RefCountingListener refs = new RefCountingListener(listener.map(unused -> new ComputeResponse(collectedProfiles)));){
            exchangeSink.addCompletionListener(refs.acquire());
            exchangeSource.addCompletionListener(refs.acquire());
            ExchangeSinkExec coordinatorPlan = new ExchangeSinkExec(plan.source(), plan.output(), plan.isIntermediateAgg(), new ExchangeSourceExec(plan.source(), plan.output(), plan.isIntermediateAgg()));
            this.runCompute(parentTask, new ComputeContext(localSessionId, clusterAlias, List.of(), configuration, exchangeSource, exchangeSink), coordinatorPlan, (ActionListener<List<DriverProfile>>)this.cancelOnFailure(parentTask, cancelled, (ActionListener<Void>)refs.acquire()).map(driverProfiles -> {
                responseHeadersCollector.collect();
                if (configuration.profile()) {
                    collectedProfiles.addAll(driverProfiles);
                }
                return null;
            }));
            this.startComputeOnDataNodes(localSessionId, clusterAlias, parentTask, configuration, plan, concreteIndices, originalIndices, exchangeSource, (ActionListener<Void>)ActionListener.releaseAfter((ActionListener)refs.acquire(), (Releasable)exchangeSource.addEmptySink()), () -> this.cancelOnFailure(parentTask, cancelled, (ActionListener<Void>)refs.acquire()).map(r -> {
                responseHeadersCollector.collect();
                if (configuration.profile()) {
                    collectedProfiles.addAll(r.getProfiles());
                }
                return null;
            }));
        }
    }

    private class DataNodeRequestHandler
    implements TransportRequestHandler<DataNodeRequest> {
        private DataNodeRequestHandler() {
        }

        public void messageReceived(DataNodeRequest request, TransportChannel channel, Task task) {
            List fragments;
            ExchangeSinkExec plan;
            ChannelActionListener listener = new ChannelActionListener(channel);
            PhysicalPlan physicalPlan = request.plan();
            if (physicalPlan instanceof ExchangeSinkExec) {
                plan = (ExchangeSinkExec)physicalPlan;
                fragments = plan.collectFirstChildren(FragmentExec.class::isInstance);
                if (fragments.isEmpty()) {
                    listener.onFailure((Exception)new IllegalStateException("expected a fragment plan for a remote compute; got " + request.plan()));
                    return;
                }
            } else {
                listener.onFailure((Exception)new IllegalStateException("expected exchange sink for a remote compute; got " + request.plan()));
                return;
            }
            ExchangeSourceExec localExchangeSource = new ExchangeSourceExec(plan.source(), plan.output(), plan.isIntermediateAgg());
            FragmentExec fragment = (FragmentExec)fragments.get(0);
            ExchangeSinkExec reducePlan = new ExchangeSinkExec(plan.source(), plan.output(), plan.isIntermediateAgg(), fragment.reducer() != null ? (PhysicalPlan)fragment.reducer().replaceChildren(List.of(localExchangeSource)) : localExchangeSource);
            String sessionId = request.sessionId();
            request = new DataNodeRequest(sessionId + "[n]", request.configuration(), request.clusterAlias(), request.shardIds(), request.aliasFilters(), request.plan());
            ComputeService.this.runComputeOnDataNode((CancellableTask)task, sessionId, reducePlan, request, (ActionListener<ComputeResponse>)listener);
        }
    }

    private class ClusterRequestHandler
    implements TransportRequestHandler<ClusterComputeRequest> {
        private ClusterRequestHandler() {
        }

        public void messageReceived(ClusterComputeRequest request, TransportChannel channel, Task task) {
            ChannelActionListener listener = new ChannelActionListener(channel);
            if (!(request.plan() instanceof ExchangeSinkExec)) {
                listener.onFailure((Exception)new IllegalStateException("expected exchange sink for a remote compute; got " + request.plan()));
                return;
            }
            ComputeService.this.runComputeOnRemoteCluster(request.clusterAlias(), request.sessionId(), (CancellableTask)task, request.configuration(), (ExchangeSinkExec)request.plan(), Set.of(request.indices()), request.originalIndices(), (ActionListener<ComputeResponse>)listener);
        }
    }

    record ComputeContext(String sessionId, String clusterAlias, List<SearchContext> searchContexts, EsqlConfiguration configuration, ExchangeSourceHandler exchangeSource, ExchangeSinkHandler exchangeSink) {
        public List<SearchExecutionContext> searchExecutionContexts() {
            return this.searchContexts.stream().map(ctx -> ctx.getSearchExecutionContext()).toList();
        }
    }

    record RemoteCluster(String clusterAlias, Transport.Connection connection, String[] concreteIndices, String[] originalIndices) {
    }

    private class DataNodeRequestExecutor {
        private final DataNodeRequest request;
        private final CancellableTask parentTask;
        private final ExchangeSinkHandler exchangeSink;
        private final ActionListener<Void> listener;
        private final List<DriverProfile> driverProfiles;
        private final int maxConcurrentShards;
        private final ExchangeSink blockingSink;

        DataNodeRequestExecutor(DataNodeRequest request, CancellableTask parentTask, ExchangeSinkHandler exchangeSink, int maxConcurrentShards, List<DriverProfile> driverProfiles, ActionListener<Void> listener) {
            this.request = request;
            this.parentTask = parentTask;
            this.exchangeSink = exchangeSink;
            this.listener = listener;
            this.driverProfiles = driverProfiles;
            this.maxConcurrentShards = maxConcurrentShards;
            this.blockingSink = exchangeSink.createExchangeSink();
        }

        void start() {
            this.parentTask.addListener(() -> ComputeService.this.exchangeService.finishSinkHandler(this.request.sessionId(), (Exception)new TaskCancelledException(this.parentTask.getReasonCancelled())));
            this.runBatch(0);
        }

        private void runBatch(int startBatchIndex) {
            EsqlConfiguration configuration = this.request.configuration();
            String clusterAlias = this.request.clusterAlias();
            String sessionId = this.request.sessionId();
            int endBatchIndex = Math.min(startBatchIndex + this.maxConcurrentShards, this.request.shardIds().size());
            List<ShardId> shardIds = this.request.shardIds().subList(startBatchIndex, endBatchIndex);
            ComputeService.this.acquireSearchContexts(clusterAlias, shardIds, configuration, this.request.aliasFilters(), (ActionListener<List<SearchContext>>)ActionListener.wrap(searchContexts -> {
                assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"search", "esql_worker"}));
                ComputeContext computeContext = new ComputeContext(sessionId, clusterAlias, (List<SearchContext>)searchContexts, configuration, null, this.exchangeSink);
                ComputeService.this.runCompute(this.parentTask, computeContext, this.request.plan(), (ActionListener<List<DriverProfile>>)ActionListener.wrap(profiles -> this.onBatchCompleted(endBatchIndex, (List<DriverProfile>)profiles), this::onFailure));
            }, this::onFailure));
        }

        private void onBatchCompleted(int lastBatchIndex, List<DriverProfile> batchProfiles) {
            if (this.request.configuration().profile()) {
                this.driverProfiles.addAll(batchProfiles);
            }
            if (lastBatchIndex < this.request.shardIds().size() && !this.exchangeSink.isFinished()) {
                this.runBatch(lastBatchIndex);
            } else {
                this.blockingSink.finish();
                this.exchangeSink.addCompletionListener((ActionListener)ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.runBefore(this.listener, () -> ComputeService.this.exchangeService.finishSinkHandler(this.request.sessionId(), null)), (ThreadContext)ComputeService.this.transportService.getThreadPool().getThreadContext()));
            }
        }

        private void onFailure(Exception e) {
            ComputeService.this.exchangeService.finishSinkHandler(this.request.sessionId(), e);
            this.listener.onFailure(e);
        }
    }

    record DataNode(Transport.Connection connection, List<ShardId> shardIds, Map<Index, AliasFilter> aliasFilters) {
    }

    public record Result(List<Page> pages, List<DriverProfile> profiles) {
    }
}

