/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.NoopCircuitBreaker;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalLogicalPlanOptimizer;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.LocalPhysicalPlanOptimizer;
import org.elasticsearch.xpack.esql.plan.logical.TopN;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EsSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSourceExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.LimitExec;
import org.elasticsearch.xpack.esql.plan.physical.OrderExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plan.physical.TopNExec;
import org.elasticsearch.xpack.esql.planner.Mapper;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.stats.SearchStats;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.AttributeSet;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.predicate.Predicates;
import org.elasticsearch.xpack.ql.plan.logical.Aggregate;
import org.elasticsearch.xpack.ql.plan.logical.EsRelation;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.Holder;
import org.elasticsearch.xpack.ql.util.Queries;

public class PlannerUtils {
    @Deprecated(forRemoval=true)
    public static final BlockFactory NON_BREAKING_BLOCK_FACTORY = BlockFactory.getInstance((CircuitBreaker)new NoopCircuitBreaker("noop-esql-breaker"), (BigArrays)BigArrays.NON_RECYCLING_INSTANCE);

    public static Tuple<PhysicalPlan, PhysicalPlan> breakPlanBetweenCoordinatorAndDataNode(PhysicalPlan plan, EsqlConfiguration config) {
        Holder dataNodePlan = new Holder();
        PhysicalPlan coordinatorPlan = (PhysicalPlan)plan.transformUp(ExchangeExec.class, e -> {
            PhysicalPlan subplan = e.child();
            dataNodePlan.set((Object)new ExchangeSinkExec(e.source(), e.output(), e.isInBetweenAggs(), subplan));
            return new ExchangeSourceExec(e.source(), e.output(), e.isInBetweenAggs());
        });
        return new Tuple((Object)coordinatorPlan, (Object)((PhysicalPlan)((Object)dataNodePlan.get())));
    }

    public static PhysicalPlan dataNodeReductionPlan(LogicalPlan plan, PhysicalPlan unused) {
        List pipelineBreakers = plan.collectFirstChildren(Mapper::isPipelineBreaker);
        if (!pipelineBreakers.isEmpty()) {
            UnaryPlan pipelineBreaker = (UnaryPlan)pipelineBreakers.get(0);
            if (pipelineBreaker instanceof TopN) {
                TopN topN = (TopN)pipelineBreaker;
                return new TopNExec(topN.source(), unused, topN.order(), topN.limit(), 2000);
            }
            if (pipelineBreaker instanceof Limit) {
                Limit limit = (Limit)pipelineBreaker;
                return new LimitExec(limit.source(), unused, limit.limit());
            }
            if (pipelineBreaker instanceof OrderBy) {
                OrderBy order = (OrderBy)pipelineBreaker;
                return new OrderExec(order.source(), unused, order.order());
            }
            if (pipelineBreaker instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)pipelineBreaker;
                return null;
            }
            throw new EsqlIllegalArgumentException("unsupported unary physical plan node [" + pipelineBreaker.nodeName() + "]");
        }
        return null;
    }

    public static Set<String> planConcreteIndices(PhysicalPlan plan) {
        if (plan == null) {
            return Set.of();
        }
        LinkedHashSet<String> indices = new LinkedHashSet<String>();
        plan.forEachUp(FragmentExec.class, f -> f.fragment().forEachUp(EsRelation.class, r -> indices.addAll(r.index().concreteIndices())));
        return indices;
    }

    public static String[] planOriginalIndices(PhysicalPlan plan) {
        if (plan == null) {
            return Strings.EMPTY_ARRAY;
        }
        LinkedHashSet indices = new LinkedHashSet();
        plan.forEachUp(FragmentExec.class, f -> f.fragment().forEachUp(EsRelation.class, r -> indices.addAll(Arrays.asList(Strings.commaDelimitedListToStringArray((String)r.index().name())))));
        return (String[])indices.toArray(String[]::new);
    }

    public static PhysicalPlan localPlan(List<SearchExecutionContext> searchContexts, EsqlConfiguration configuration, PhysicalPlan plan) {
        return PlannerUtils.localPlan(configuration, plan, new SearchStats(searchContexts));
    }

    public static PhysicalPlan localPlan(EsqlConfiguration configuration, PhysicalPlan plan, SearchStats searchStats) {
        LocalLogicalPlanOptimizer logicalOptimizer = new LocalLogicalPlanOptimizer(new LocalLogicalOptimizerContext(configuration, searchStats));
        LocalPhysicalPlanOptimizer physicalOptimizer = new LocalPhysicalPlanOptimizer(new LocalPhysicalOptimizerContext(configuration, searchStats));
        return PlannerUtils.localPlan(plan, logicalOptimizer, physicalOptimizer);
    }

    public static PhysicalPlan localPlan(PhysicalPlan plan, LocalLogicalPlanOptimizer logicalOptimizer, LocalPhysicalPlanOptimizer physicalOptimizer) {
        Mapper mapper = new Mapper(true);
        Holder isCoordPlan = new Holder((Object)Boolean.TRUE);
        PhysicalPlan localPhysicalPlan = (PhysicalPlan)plan.transformUp(FragmentExec.class, f -> {
            isCoordPlan.set((Object)Boolean.FALSE);
            LogicalPlan optimizedFragment = logicalOptimizer.localOptimize(f.fragment());
            PhysicalPlan physicalFragment = mapper.map(optimizedFragment);
            QueryBuilder filter = f.esFilter();
            if (filter != null) {
                physicalFragment = (PhysicalPlan)physicalFragment.transformUp(EsSourceExec.class, query -> new EsSourceExec(Source.EMPTY, query.index(), query.output(), filter));
            }
            PhysicalPlan localOptimized = physicalOptimizer.localOptimize(physicalFragment);
            return EstimatesRowSize.estimateRowSize(f.estimatedRowSize(), localOptimized);
        });
        return (Boolean)isCoordPlan.get() != false ? plan : localPhysicalPlan;
    }

    public static QueryBuilder requestFilter(PhysicalPlan plan, Predicate<FieldAttribute> hasIdenticalDelegate) {
        return PlannerUtils.detectFilter(plan, "@timestamp", hasIdenticalDelegate);
    }

    static QueryBuilder detectFilter(PhysicalPlan plan, String fieldName, Predicate<FieldAttribute> hasIdenticalDelegate) {
        QueryBuilder[] requestFilter = new QueryBuilder[]{null, null};
        plan.forEachDown(FragmentExec.class, fe -> {
            requestFilter[0] = fe.esFilter();
            fe.fragment().forEachUp(Filter.class, f -> {
                ArrayList<Expression> matches = new ArrayList<Expression>();
                if (f.child() instanceof EsRelation) {
                    List conjunctions = Predicates.splitAnd((Expression)f.condition());
                    for (Expression exp : conjunctions) {
                        AttributeSet refs = new AttributeSet((Collection)exp.references());
                        boolean matchesField = refs.removeIf(e -> fieldName.equals(e.name()));
                        if (!matchesField || !refs.isEmpty() || !LocalPhysicalPlanOptimizer.PushFiltersToSource.canPushToSource(exp, hasIdenticalDelegate)) continue;
                        matches.add(exp);
                    }
                }
                if (matches.size() > 0) {
                    requestFilter[1] = LocalPhysicalPlanOptimizer.TRANSLATOR_HANDLER.asQuery(Predicates.combineAnd(matches)).asBuilder();
                }
            });
        });
        return Queries.combine((Queries.Clause)Queries.Clause.FILTER, Arrays.asList(requestFilter));
    }

    public static ElementType toSortableElementType(DataType dataType) {
        if (EsqlDataTypes.isSpatial(dataType)) {
            return ElementType.UNKNOWN;
        }
        return PlannerUtils.toElementType(dataType);
    }

    public static ElementType toElementType(DataType dataType) {
        return PlannerUtils.toElementType(dataType, MappedFieldType.FieldExtractPreference.NONE);
    }

    public static ElementType toElementType(DataType dataType, MappedFieldType.FieldExtractPreference fieldExtractPreference) {
        if (dataType == DataTypes.LONG || dataType == DataTypes.DATETIME || dataType == DataTypes.UNSIGNED_LONG) {
            return ElementType.LONG;
        }
        if (dataType == DataTypes.INTEGER) {
            return ElementType.INT;
        }
        if (dataType == DataTypes.DOUBLE) {
            return ElementType.DOUBLE;
        }
        if (dataType == DataTypes.KEYWORD || dataType == DataTypes.TEXT || dataType == DataTypes.IP || dataType == DataTypes.SOURCE || dataType == DataTypes.VERSION || dataType == DataTypes.UNSUPPORTED) {
            return ElementType.BYTES_REF;
        }
        if (dataType == DataTypes.NULL) {
            return ElementType.NULL;
        }
        if (dataType == DataTypes.BOOLEAN) {
            return ElementType.BOOLEAN;
        }
        if (dataType == EsQueryExec.DOC_DATA_TYPE) {
            return ElementType.DOC;
        }
        if (EsqlDataTypes.isSpatialPoint(dataType)) {
            return fieldExtractPreference == MappedFieldType.FieldExtractPreference.DOC_VALUES ? ElementType.LONG : ElementType.BYTES_REF;
        }
        if (EsqlDataTypes.isSpatial(dataType)) {
            return ElementType.BYTES_REF;
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    public static MappedFieldType.FieldExtractPreference extractPreference(boolean hasPreference) {
        return hasPreference ? MappedFieldType.FieldExtractPreference.DOC_VALUES : MappedFieldType.FieldExtractPreference.NONE;
    }
}

