/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.elasticsearch.xpack.esql.planner.DefaultLayout;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.type.DataType;

public interface Layout {
    public ChannelAndType get(NameId var1);

    public int numberOfChannels();

    public Builder builder();

    public List<ChannelSet> inverse();

    public static class Builder {
        private final List<ChannelSet> channels;

        public Builder() {
            this.channels = new ArrayList<ChannelSet>();
        }

        Builder(List<ChannelSet> channels) {
            this.channels = channels;
        }

        public Builder append(ChannelSet set) {
            if (set.nameIds.size() < 1) {
                throw new IllegalArgumentException("Channel must be mapped to at least one id.");
            }
            this.channels.add(set);
            return this;
        }

        public Builder append(NamedExpression attribute) {
            return this.append(new ChannelSet(Set.of(attribute.id()), attribute.dataType()));
        }

        public Builder append(Collection<? extends NamedExpression> attributes) {
            for (NamedExpression namedExpression : attributes) {
                this.append(new ChannelSet(Set.of(namedExpression.id()), namedExpression.dataType()));
            }
            return this;
        }

        public Layout build() {
            HashMap<NameId, ChannelAndType> layout = new HashMap<NameId, ChannelAndType>();
            int numberOfChannels = 0;
            for (ChannelSet set : this.channels) {
                int channel = numberOfChannels++;
                for (NameId id : set.nameIds) {
                    ChannelAndType next = new ChannelAndType(channel, set.type);
                    ChannelAndType channelAndType = layout.put(id, next);
                }
            }
            return new DefaultLayout(Collections.unmodifiableMap(layout), numberOfChannels);
        }

        public void replace(NameId id, NameId id1) {
            for (ChannelSet channel : this.channels) {
                if (channel == null || !channel.nameIds.contains(id)) continue;
                channel.nameIds.remove(id);
                channel.nameIds.add(id1);
            }
        }
    }

    public record ChannelSet(Set<NameId> nameIds, DataType type) {
    }

    public record ChannelAndType(int channel, DataType type) {
    }
}

