/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.planner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.xpack.esql.planner.Layout;
import org.elasticsearch.xpack.ql.expression.NameId;

class DefaultLayout
implements Layout {
    private final Map<NameId, Layout.ChannelAndType> layout;
    private final int numberOfChannels;

    DefaultLayout(Map<NameId, Layout.ChannelAndType> layout, int numberOfChannels) {
        this.layout = layout;
        this.numberOfChannels = numberOfChannels;
    }

    @Override
    public Layout.ChannelAndType get(NameId id) {
        return this.layout.get(id);
    }

    @Override
    public int numberOfChannels() {
        return this.numberOfChannels;
    }

    @Override
    public List<Layout.ChannelSet> inverse() {
        ArrayList<Layout.ChannelSet> inverse = new ArrayList<Layout.ChannelSet>(this.numberOfChannels);
        for (int i = 0; i < this.numberOfChannels; ++i) {
            inverse.add(null);
        }
        for (Map.Entry<NameId, Layout.ChannelAndType> entry : this.layout.entrySet()) {
            Layout.ChannelSet set = (Layout.ChannelSet)inverse.get(entry.getValue().channel());
            if (set == null) {
                set = new Layout.ChannelSet(new HashSet<NameId>(), entry.getValue().type());
                inverse.set(entry.getValue().channel(), set);
            } else if (set.type() != entry.getValue().type()) {
                throw new IllegalArgumentException();
            }
            set.nameIds().add(entry.getKey());
        }
        return inverse;
    }

    @Override
    public Layout.Builder builder() {
        return new Layout.Builder(this.inverse());
    }

    public String toString() {
        return "Layout{layout=" + this.layout + ", numberOfChannels=" + this.numberOfChannels + "}";
    }
}

