/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.plan.physical.EsQueryExec;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public class EsTimeseriesQueryExec
extends EsQueryExec {
    static final EsField TSID_FIELD = new EsField("_tsid", DataTypes.KEYWORD, Map.of(), true);
    static final EsField TIMESTAMP_FIELD = new EsField("@timestamp", DataTypes.DATETIME, Map.of(), true);
    static final EsField INTERVAL_FIELD = new EsField("timestamp_interval", DataTypes.DATETIME, Map.of(), true);

    public EsTimeseriesQueryExec(Source source, EsIndex index, QueryBuilder query) {
        this(source, index, List.of(new FieldAttribute(source, DOC_ID_FIELD.getName(), DOC_ID_FIELD), new FieldAttribute(source, TSID_FIELD.getName(), TSID_FIELD), new FieldAttribute(source, TIMESTAMP_FIELD.getName(), TIMESTAMP_FIELD), new FieldAttribute(source, INTERVAL_FIELD.getName(), INTERVAL_FIELD)), query, null, null, null);
    }

    public EsTimeseriesQueryExec(Source source, EsIndex index, List<Attribute> attrs, QueryBuilder query, Expression limit, List<EsQueryExec.FieldSort> sorts, Integer estimatedRowSize) {
        super(source, index, attrs, query, limit, sorts, estimatedRowSize);
    }

    @Override
    protected NodeInfo<EsQueryExec> info() {
        return NodeInfo.create((Node)this, EsTimeseriesQueryExec::new, (Object)this.index(), this.attrs(), (Object)this.query(), (Object)this.limit(), this.sorts(), (Object)this.estimatedRowSize());
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int size;
        if (this.sorts() == null || this.sorts().isEmpty()) {
            state.add(false, 4);
            size = state.consumeAllFields(false);
        } else {
            state.add(false, 8);
            size = state.consumeAllFields(true);
        }
        return Objects.equals(this.estimatedRowSize(), size) ? this : new EsTimeseriesQueryExec(this.source(), this.index(), this.attrs(), this.query(), this.limit(), this.sorts(), size);
    }

    @Override
    public EsQueryExec withLimit(Expression limit) {
        return Objects.equals(this.limit(), limit) ? this : new EsTimeseriesQueryExec(this.source(), this.index(), this.attrs(), this.query(), limit, this.sorts(), this.estimatedRowSize());
    }

    @Override
    public EsQueryExec withSorts(List<EsQueryExec.FieldSort> sorts) {
        return Objects.equals(this.sorts(), sorts) ? this : new EsTimeseriesQueryExec(this.source(), this.index(), this.attrs(), this.query(), this.limit(), sorts, this.estimatedRowSize());
    }
}

