/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.physical;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.esql.plan.physical.EstimatesRowSize;
import org.elasticsearch.xpack.esql.plan.physical.LeafExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.index.EsIndex;
import org.elasticsearch.xpack.ql.querydsl.container.Sort;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.NodeUtils;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.EsField;

public class EsQueryExec
extends LeafExec
implements EstimatesRowSize {
    public static final DataType DOC_DATA_TYPE = new DataType("_doc", 12, false, false, false);
    static final EsField DOC_ID_FIELD = new EsField("_doc", DOC_DATA_TYPE, Map.of(), false);
    private final EsIndex index;
    private final QueryBuilder query;
    private final Expression limit;
    private final List<FieldSort> sorts;
    private final List<Attribute> attrs;
    private final Integer estimatedRowSize;

    public static boolean isSourceAttribute(Attribute attr) {
        return "_doc".equals(attr.name());
    }

    public EsQueryExec(Source source, EsIndex index, QueryBuilder query) {
        this(source, index, List.of(new FieldAttribute(source, DOC_ID_FIELD.getName(), DOC_ID_FIELD)), query, null, null, null);
    }

    public EsQueryExec(Source source, EsIndex index, List<Attribute> attrs, QueryBuilder query, Expression limit, List<FieldSort> sorts, Integer estimatedRowSize) {
        super(source);
        this.index = index;
        this.query = query;
        this.attrs = attrs;
        this.limit = limit;
        this.sorts = sorts;
        this.estimatedRowSize = estimatedRowSize;
    }

    protected NodeInfo<EsQueryExec> info() {
        return NodeInfo.create((Node)this, EsQueryExec::new, (Object)this.index, this.attrs, (Object)this.query, (Object)this.limit, this.sorts, (Object)this.estimatedRowSize);
    }

    public EsIndex index() {
        return this.index;
    }

    public QueryBuilder query() {
        return this.query;
    }

    public List<Attribute> output() {
        return this.attrs;
    }

    public Expression limit() {
        return this.limit;
    }

    public List<FieldSort> sorts() {
        return this.sorts;
    }

    public List<Attribute> attrs() {
        return this.attrs;
    }

    public Integer estimatedRowSize() {
        return this.estimatedRowSize;
    }

    @Override
    public PhysicalPlan estimateRowSize(EstimatesRowSize.State state) {
        int size;
        if (this.sorts == null || this.sorts.isEmpty()) {
            state.add(false, 4);
            size = state.consumeAllFields(false);
        } else {
            state.add(false, 8);
            size = state.consumeAllFields(true);
        }
        return Objects.equals(this.estimatedRowSize, size) ? this : new EsQueryExec(this.source(), this.index, this.attrs, this.query, this.limit, this.sorts, size);
    }

    public EsQueryExec withLimit(Expression limit) {
        return Objects.equals(this.limit, limit) ? this : new EsQueryExec(this.source(), this.index, this.attrs, this.query, limit, this.sorts, this.estimatedRowSize);
    }

    public EsQueryExec withSorts(List<FieldSort> sorts) {
        return Objects.equals(this.sorts, sorts) ? this : new EsQueryExec(this.source(), this.index, this.attrs, this.query, this.limit, sorts, this.estimatedRowSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.attrs, this.query, this.limit, this.sorts);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EsQueryExec other = (EsQueryExec)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.attrs, other.attrs) && Objects.equals(this.query, other.query) && Objects.equals(this.limit, other.limit) && Objects.equals(this.sorts, other.sorts) && Objects.equals(this.estimatedRowSize, other.estimatedRowSize);
    }

    public String nodeString() {
        return this.nodeName() + "[" + this.index + "], query[" + (this.query != null ? Strings.toString((ToXContent)this.query, (boolean)false, (boolean)true) : "") + "]" + NodeUtils.limitedToString(this.attrs) + ", limit[" + (this.limit != null ? this.limit.toString() : "") + "], sort[" + (this.sorts != null ? this.sorts.toString() : "") + "] estimatedRowSize[" + this.estimatedRowSize + "]";
    }

    public record FieldSort(FieldAttribute field, Order.OrderDirection direction, Order.NullsPosition nulls) {
        public FieldSortBuilder fieldSortBuilder() {
            FieldSortBuilder builder = new FieldSortBuilder(this.field.name());
            builder.order(Sort.Direction.from((Order.OrderDirection)this.direction).asOrder());
            builder.missing((Object)Sort.Missing.from((Order.NullsPosition)this.nulls).searchOrder());
            builder.unmappedType(this.field.dataType().esType());
            return builder;
        }
    }
}

