/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xpack.core.enrich.EnrichPolicy;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Enrich
extends UnaryPlan {
    private final Expression policyName;
    private final NamedExpression matchField;
    private final EnrichPolicy policy;
    private final Map<String, String> concreteIndices;
    private final List<NamedExpression> enrichFields;
    private List<Attribute> output;
    private final Mode mode;

    public Enrich(Source source, LogicalPlan child, Mode mode, Expression policyName, NamedExpression matchField, EnrichPolicy policy, Map<String, String> concreteIndices, List<NamedExpression> enrichFields) {
        super(source, child);
        this.mode = mode == null ? Mode.ANY : mode;
        this.policyName = policyName;
        this.matchField = matchField;
        this.policy = policy;
        this.concreteIndices = concreteIndices;
        this.enrichFields = enrichFields;
    }

    public NamedExpression matchField() {
        return this.matchField;
    }

    public List<NamedExpression> enrichFields() {
        return this.enrichFields;
    }

    public EnrichPolicy policy() {
        return this.policy;
    }

    public Map<String, String> concreteIndices() {
        return this.concreteIndices;
    }

    public Expression policyName() {
        return this.policyName;
    }

    public Mode mode() {
        return this.mode;
    }

    public boolean expressionsResolved() {
        return this.policyName.resolved() && !(this.matchField instanceof EmptyAttribute) && this.matchField.resolved() && Resolvables.resolved(this.enrichFields());
    }

    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Enrich(this.source(), newChild, this.mode, this.policyName, this.matchField, this.policy, this.concreteIndices, this.enrichFields);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Enrich::new, (Object)this.child(), (Object)((Object)this.mode), (Object)this.policyName, (Object)this.matchField, (Object)this.policy, this.concreteIndices, this.enrichFields);
    }

    public List<Attribute> output() {
        if (this.enrichFields == null) {
            return this.child().output();
        }
        if (this.output == null) {
            this.output = NamedExpressions.mergeOutputAttributes(this.enrichFields(), this.child().output());
        }
        return this.output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Enrich enrich = (Enrich)((Object)o);
        return Objects.equals((Object)this.mode, (Object)enrich.mode) && Objects.equals(this.policyName, enrich.policyName) && Objects.equals(this.matchField, enrich.matchField) && Objects.equals(this.policy, enrich.policy) && Objects.equals(this.concreteIndices, enrich.concreteIndices) && Objects.equals(this.enrichFields, enrich.enrichFields);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.mode, this.policyName, this.matchField, this.policy, this.concreteIndices, this.enrichFields});
    }

    public static enum Mode {
        ANY,
        COORDINATOR,
        REMOTE;

        private static final Map<String, Mode> map;

        public static Mode from(String name) {
            return name == null ? null : map.get(name.toUpperCase(Locale.ROOT));
        }

        static {
            Mode[] values = Mode.values();
            map = Maps.newMapWithExpectedSize((int)values.length);
            for (Mode m : values) {
                map.put(m.name(), m);
            }
        }
    }
}

