/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.elasticsearch.common.logging.HeaderWarning;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.dissect.DissectException;
import org.elasticsearch.dissect.DissectParser;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.expression.UnresolvedNamePattern;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.esql.parser.ExpressionBuilder;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.parser.TypedParamValue;
import org.elasticsearch.xpack.esql.plan.logical.Dissect;
import org.elasticsearch.xpack.esql.plan.logical.Drop;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.EsqlAggregate;
import org.elasticsearch.xpack.esql.plan.logical.EsqlUnresolvedRelation;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Explain;
import org.elasticsearch.xpack.esql.plan.logical.Grok;
import org.elasticsearch.xpack.esql.plan.logical.InlineStats;
import org.elasticsearch.xpack.esql.plan.logical.Keep;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.Rename;
import org.elasticsearch.xpack.esql.plan.logical.Row;
import org.elasticsearch.xpack.esql.plan.logical.meta.MetaFunctions;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowInfo;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.common.Failure;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.MetadataAttribute;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.expression.Order;
import org.elasticsearch.xpack.ql.expression.ReferenceAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.ql.expression.UnresolvedStar;
import org.elasticsearch.xpack.ql.expression.function.UnresolvedFunction;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.plan.TableIdentifier;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.Limit;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.OrderBy;
import org.elasticsearch.xpack.ql.tree.Location;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class LogicalPlanBuilder
extends ExpressionBuilder {
    private int queryDepth = 0;
    public static final int MAX_QUERY_DEPTH = 500;

    public LogicalPlanBuilder(Map<Token, TypedParamValue> params) {
        super(params);
    }

    protected LogicalPlan plan(ParseTree ctx) {
        return (LogicalPlan)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx, LogicalPlan.class);
    }

    protected List<LogicalPlan> plans(List<? extends ParserRuleContext> ctxs) {
        return ParserUtils.visitList((ParseTreeVisitor)this, ctxs, LogicalPlan.class);
    }

    @Override
    public LogicalPlan visitSingleStatement(EsqlBaseParser.SingleStatementContext ctx) {
        return this.plan((ParseTree)ctx.query());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogicalPlan visitCompositeQuery(EsqlBaseParser.CompositeQueryContext ctx) {
        ++this.queryDepth;
        if (this.queryDepth > 500) {
            throw new ParsingException("ESQL statement exceeded the maximum query depth allowed ({}): [{}]", 500, ctx.getText());
        }
        try {
            LogicalPlan input = this.plan((ParseTree)ctx.query());
            PlanFactory makePlan = (PlanFactory)ParserUtils.typedParsing((ParseTreeVisitor)this, (ParseTree)ctx.processingCommand(), PlanFactory.class);
            LogicalPlan logicalPlan = (LogicalPlan)makePlan.apply(input);
            return logicalPlan;
        }
        finally {
            --this.queryDepth;
        }
    }

    @Override
    public PlanFactory visitEvalCommand(EsqlBaseParser.EvalCommandContext ctx) {
        return p -> new Eval(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)p, (List<Alias>)this.visitFields(ctx.fields()));
    }

    @Override
    public PlanFactory visitGrokCommand(EsqlBaseParser.GrokCommandContext ctx) {
        return p -> {
            String pattern = this.visitString(ctx.string()).fold().toString();
            Grok result = new Grok(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)p, this.expression((ParseTree)ctx.primaryExpression()), Grok.pattern(ParserUtils.source((ParserRuleContext)ctx), pattern));
            return result;
        };
    }

    @Override
    public PlanFactory visitDissectCommand(EsqlBaseParser.DissectCommandContext ctx) {
        return p -> {
            String pattern = this.visitString(ctx.string()).fold().toString();
            Object options = this.visitCommandOptions(ctx.commandOptions());
            String appendSeparator = "";
            for (Map.Entry item : options.entrySet()) {
                if (!((String)item.getKey()).equalsIgnoreCase("append_separator")) {
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "Invalid option for dissect: [{}]", item.getKey());
                }
                if (!(item.getValue() instanceof String)) {
                    throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "Invalid value for dissect append_separator: expected a string, but was [{}]", item.getValue());
                }
                appendSeparator = (String)item.getValue();
            }
            Source src = ParserUtils.source((ParserRuleContext)ctx);
            try {
                DissectParser parser = new DissectParser(pattern, appendSeparator);
                Set referenceKeys = parser.referenceKeys();
                if (referenceKeys.size() > 0) {
                    throw new ParsingException(src, "Reference keys not supported in dissect patterns: [%{*{}}]", referenceKeys.iterator().next());
                }
                ArrayList<Attribute> keys = new ArrayList<Attribute>();
                for (String x : parser.outputKeys()) {
                    if (x.isEmpty()) continue;
                    keys.add((Attribute)new ReferenceAttribute(src, x, DataTypes.KEYWORD));
                }
                return new Dissect(src, (LogicalPlan)p, this.expression((ParseTree)ctx.primaryExpression()), new Dissect.Parser(pattern, appendSeparator, parser), (List<Attribute>)keys);
            }
            catch (DissectException e) {
                throw new ParsingException(src, "Invalid pattern for dissect: [{}]", pattern);
            }
        };
    }

    @Override
    public PlanFactory visitMvExpandCommand(EsqlBaseParser.MvExpandCommandContext ctx) {
        UnresolvedAttribute field = this.visitQualifiedName(ctx.qualifiedName());
        Source src = ParserUtils.source((ParserRuleContext)ctx);
        return child -> new MvExpand(src, (LogicalPlan)child, (NamedExpression)field, (Attribute)new UnresolvedAttribute(src, field.name()));
    }

    @Override
    public Map<String, Object> visitCommandOptions(EsqlBaseParser.CommandOptionsContext ctx) {
        if (ctx == null) {
            return Map.of();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (EsqlBaseParser.CommandOptionContext option : ctx.commandOption()) {
            result.put(this.visitIdentifier(option.identifier()), this.expression((ParseTree)option.constant()).fold());
        }
        return result;
    }

    @Override
    public LogicalPlan visitRowCommand(EsqlBaseParser.RowCommandContext ctx) {
        return new Row(ParserUtils.source((ParserRuleContext)ctx), (List<Alias>)this.visitFields(ctx.fields()));
    }

    @Override
    public LogicalPlan visitFromCommand(EsqlBaseParser.FromCommandContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        TableIdentifier table = new TableIdentifier(source, null, this.visitFromIdentifiers((List)ctx.fromIdentifier()));
        LinkedHashMap<String, MetadataAttribute> metadataMap = new LinkedHashMap<String, MetadataAttribute>();
        if (ctx.metadata() != null) {
            EsqlBaseParser.Deprecated_metadataContext deprecatedContext = ctx.metadata().deprecated_metadata();
            EsqlBaseParser.MetadataOptionContext metadataOptionContext = null;
            if (deprecatedContext != null) {
                Location s = ParserUtils.source((ParserRuleContext)deprecatedContext).source();
                HeaderWarning.addWarning((String)"Line {}:{}: Square brackets '[]' need to be removed in FROM METADATA declaration", (Object[])new Object[]{s.getLineNumber(), s.getColumnNumber()});
                metadataOptionContext = deprecatedContext.metadataOption();
            } else {
                metadataOptionContext = ctx.metadata().metadataOption();
            }
            for (EsqlBaseParser.FromIdentifierContext c : metadataOptionContext.fromIdentifier()) {
                String id = this.visitFromIdentifier(c);
                Source src = ParserUtils.source((ParserRuleContext)c);
                if (!MetadataAttribute.isSupported((String)id)) {
                    throw new ParsingException(src, "unsupported metadata field [" + id + "]", new Object[0]);
                }
                Attribute a = (Attribute)metadataMap.put(id, MetadataAttribute.create((Source)src, (String)id));
                if (a == null) continue;
                throw new ParsingException(src, "metadata field [" + id + "] already declared [" + a.source().source() + "]", new Object[0]);
            }
        }
        return new EsqlUnresolvedRelation(source, table, Arrays.asList((Attribute[])metadataMap.values().toArray(Attribute[]::new)));
    }

    @Override
    public PlanFactory visitStatsCommand(EsqlBaseParser.StatsCommandContext ctx) {
        ArrayList<Attribute> aggregates = new ArrayList<Attribute>((Collection<Attribute>)this.visitFields(ctx.stats));
        List<NamedExpression> groupings = this.visitGrouping(ctx.grouping);
        if (aggregates.isEmpty() && groupings.isEmpty()) {
            throw new ParsingException(ParserUtils.source((ParserRuleContext)ctx), "At least one aggregation or grouping expression required in [{}]", ctx.getText());
        }
        if (!groupings.isEmpty() && !aggregates.isEmpty()) {
            LinkedHashSet groupNames = new LinkedHashSet(Expressions.names(groupings));
            LinkedHashSet linkedHashSet = new LinkedHashSet(Expressions.names((Collection)Expressions.references(groupings)));
            for (NamedExpression namedExpression : aggregates) {
                Expression e = Alias.unwrap((Expression)namedExpression);
                if (e.resolved() || e instanceof UnresolvedFunction) continue;
                String name = e.sourceText();
                if (groupNames.contains(name)) {
                    this.fail(e, "grouping key [{}] already specified in the STATS BY clause", name);
                    continue;
                }
                if (!linkedHashSet.contains(name)) continue;
                this.fail(e, "Cannot specify grouping expression [{}] as an aggregate", name);
            }
        }
        for (Expression expression : groupings) {
            aggregates.add(Expressions.attribute((Expression)expression));
        }
        return input -> new EsqlAggregate(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)input, (List<Expression>)new ArrayList<Expression>(groupings), (List<? extends NamedExpression>)aggregates);
    }

    private void fail(Expression exp, String message, Object ... args) {
        throw new VerificationException(Collections.singletonList(Failure.fail((Node)exp, (String)message, (Object[])args)));
    }

    @Override
    public PlanFactory visitInlinestatsCommand(EsqlBaseParser.InlinestatsCommandContext ctx) {
        ArrayList<NamedExpression> aggregates = new ArrayList<NamedExpression>((Collection<NamedExpression>)this.visitFields(ctx.stats));
        List<NamedExpression> groupings = this.visitGrouping(ctx.grouping);
        aggregates.addAll(groupings);
        return input -> new InlineStats(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)input, (List<Expression>)new ArrayList<Expression>(groupings), (List<? extends NamedExpression>)aggregates);
    }

    @Override
    public PlanFactory visitWhereCommand(EsqlBaseParser.WhereCommandContext ctx) {
        Expression expression = this.expression((ParseTree)ctx.booleanExpression());
        return input -> new Filter(ParserUtils.source((ParserRuleContext)ctx), input, expression);
    }

    @Override
    public PlanFactory visitLimitCommand(EsqlBaseParser.LimitCommandContext ctx) {
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        int limit = EsqlDataTypeConverter.stringToInt(ctx.INTEGER_LITERAL().getText());
        return input -> new Limit(source, (Expression)new Literal(source, (Object)limit, DataTypes.INTEGER), input);
    }

    @Override
    public PlanFactory visitSortCommand(EsqlBaseParser.SortCommandContext ctx) {
        List orders = ParserUtils.visitList((ParseTreeVisitor)this, ctx.orderExpression(), Order.class);
        Source source = ParserUtils.source((ParserRuleContext)ctx);
        return input -> new OrderBy(source, input, orders);
    }

    @Override
    public Explain visitExplainCommand(EsqlBaseParser.ExplainCommandContext ctx) {
        return new Explain(ParserUtils.source((ParserRuleContext)ctx), this.plan((ParseTree)ctx.subqueryExpression().query()));
    }

    @Override
    public PlanFactory visitDropCommand(EsqlBaseParser.DropCommandContext ctx) {
        List<EsqlBaseParser.QualifiedNamePatternContext> identifiers = ctx.qualifiedNamePattern();
        ArrayList<NamedExpression> removals = new ArrayList<NamedExpression>(identifiers.size());
        for (EsqlBaseParser.QualifiedNamePatternContext patternContext : identifiers) {
            NamedExpression ne = this.visitQualifiedNamePattern(patternContext);
            if (ne instanceof UnresolvedStar) {
                Source src = ne.source();
                throw new ParsingException(src, "Removing all fields is not allowed [{}]", src.text());
            }
            removals.add(ne);
        }
        return child -> new Drop(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)child, (List<NamedExpression>)removals);
    }

    @Override
    public PlanFactory visitRenameCommand(EsqlBaseParser.RenameCommandContext ctx) {
        List<Alias> renamings = ctx.renameClause().stream().map(this::visitRenameClause).toList();
        return child -> new Rename(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)child, renamings);
    }

    @Override
    public PlanFactory visitKeepCommand(EsqlBaseParser.KeepCommandContext ctx) {
        List<EsqlBaseParser.QualifiedNamePatternContext> identifiers = ctx.qualifiedNamePattern();
        ArrayList<NamedExpression> projections = new ArrayList<NamedExpression>(identifiers.size());
        boolean hasSeenStar = false;
        for (EsqlBaseParser.QualifiedNamePatternContext patternContext : identifiers) {
            NamedExpression ne = this.visitQualifiedNamePattern(patternContext);
            if (ne instanceof UnresolvedStar) {
                if (hasSeenStar) {
                    Source src = ne.source();
                    throw new ParsingException(src, "Cannot specify [*] more than once", src.text());
                }
                hasSeenStar = true;
            }
            projections.add(ne);
        }
        return child -> new Keep(ParserUtils.source((ParserRuleContext)ctx), (LogicalPlan)child, (List<? extends NamedExpression>)projections);
    }

    @Override
    public LogicalPlan visitShowInfo(EsqlBaseParser.ShowInfoContext ctx) {
        return new ShowInfo(ParserUtils.source((ParserRuleContext)ctx));
    }

    @Override
    public LogicalPlan visitMetaFunctions(EsqlBaseParser.MetaFunctionsContext ctx) {
        return new MetaFunctions(ParserUtils.source((ParserRuleContext)ctx));
    }

    @Override
    public PlanFactory visitEnrichCommand(EsqlBaseParser.EnrichCommandContext ctx) {
        return p -> {
            EmptyAttribute matchField;
            Source source = ParserUtils.source((ParserRuleContext)ctx);
            Tuple<Enrich.Mode, String> tuple = LogicalPlanBuilder.parsePolicyName(ctx.policyName);
            Enrich.Mode mode = (Enrich.Mode)((Object)((Object)tuple.v1()));
            String policyNameString = (String)tuple.v2();
            Object object = matchField = ctx.ON() != null ? this.visitQualifiedNamePattern(ctx.matchField) : new EmptyAttribute(source);
            if (matchField instanceof UnresolvedNamePattern) {
                UnresolvedNamePattern up = (UnresolvedNamePattern)matchField;
                throw new ParsingException(source, "Using wildcards (*) in ENRICH WITH projections is not allowed [{}]", up.pattern());
            }
            List keepClauses = ParserUtils.visitList((ParseTreeVisitor)this, ctx.enrichWithClause(), NamedExpression.class);
            return new Enrich(source, (LogicalPlan)p, mode, (Expression)new Literal(ParserUtils.source((Token)ctx.policyName), (Object)policyNameString, DataTypes.KEYWORD), (NamedExpression)matchField, null, Map.of(), keepClauses.isEmpty() ? List.of() : keepClauses);
        };
    }

    private static Tuple<Enrich.Mode, String> parsePolicyName(Token policyToken) {
        String stringValue = policyToken.getText();
        int index = stringValue.indexOf(":");
        Enrich.Mode mode = null;
        if (index >= 0) {
            String modeValue = stringValue.substring(0, index);
            if (modeValue.startsWith("_")) {
                mode = Enrich.Mode.from(modeValue.substring(1));
            }
            if (mode == null) {
                throw new ParsingException(ParserUtils.source((Token)policyToken), "Unrecognized value [{}], ENRICH policy qualifier needs to be one of {}", modeValue, Arrays.stream(Enrich.Mode.values()).map(s -> "_" + s).toList());
            }
        } else {
            mode = Enrich.Mode.ANY;
        }
        String policyName = index < 0 ? stringValue : stringValue.substring(index + 1);
        return new Tuple((Object)mode, (Object)policyName);
    }

    static interface PlanFactory
    extends Function<LogicalPlan, LogicalPlan> {
    }
}

