/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.esql.parser.AbstractBuilder;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParser;
import org.elasticsearch.xpack.ql.parser.ParserUtils;

abstract class IdentifierBuilder
extends AbstractBuilder {
    IdentifierBuilder() {
    }

    @Override
    public String visitIdentifier(EsqlBaseParser.IdentifierContext ctx) {
        return ctx == null ? null : IdentifierBuilder.unquoteIdentifier(ctx.QUOTED_IDENTIFIER(), ctx.UNQUOTED_IDENTIFIER());
    }

    @Override
    public String visitFromIdentifier(EsqlBaseParser.FromIdentifierContext ctx) {
        return ctx == null ? null : IdentifierBuilder.unquoteIdentifier(null, ctx.FROM_UNQUOTED_IDENTIFIER());
    }

    protected static String unquoteIdentifier(TerminalNode quotedNode, TerminalNode unquotedNode) {
        String result = quotedNode != null ? IdentifierBuilder.unquoteIdString(quotedNode.getText()) : unquotedNode.getText();
        return result;
    }

    protected static String unquoteIdString(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1).replace("``", "`");
    }

    public String visitFromIdentifiers(List<EsqlBaseParser.FromIdentifierContext> ctx) {
        return Strings.collectionToDelimitedString((Iterable)ParserUtils.visitList((ParseTreeVisitor)this, ctx, String.class), (String)",");
    }
}

