/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.parser;

import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.elasticsearch.xpack.esql.parser.EsqlBaseParserBaseVisitor;
import org.elasticsearch.xpack.ql.parser.ParserUtils;
import org.elasticsearch.xpack.ql.tree.Source;

abstract class AbstractBuilder
extends EsqlBaseParserBaseVisitor<Object> {
    AbstractBuilder() {
    }

    public Object visit(ParseTree tree) {
        return ParserUtils.visit(x$0 -> super.visit(x$0), (ParseTree)tree);
    }

    public Object visitTerminal(TerminalNode node) {
        return ParserUtils.source((TerminalNode)node);
    }

    static String unquoteString(Source source) {
        String text = source.text();
        if (text == null) {
            return null;
        }
        if (text.startsWith("\"\"\"")) {
            return text.substring(3, text.length() - 3);
        }
        text = text.substring(1, text.length() - 1);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '\\') {
                switch (text.charAt(++i)) {
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    default: {
                        sb.append('\\').append(text.charAt(i));
                    }
                }
                ++i;
                continue;
            }
            sb.append(text.charAt(i++));
        }
        return sb.toString();
    }
}

