/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.util.List;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.InProcessor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.StringUtils;

public class In
extends org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.In {
    public In(Source source, Expression value, List<Expression> list) {
        super(source, value, list);
    }

    protected NodeInfo<org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.In> info() {
        return NodeInfo.create((Node)this, In::new, (Object)this.value(), (Object)this.list());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new In(this.source(), newChildren.get(newChildren.size() - 1), newChildren.subList(0, newChildren.size() - 1));
    }

    public boolean foldable() {
        return Expressions.isNull((Expression)this.value()) || super.foldable();
    }

    public Boolean fold() {
        if (Expressions.isNull((Expression)this.value()) || this.list().stream().allMatch(Expressions::isNull)) {
            return null;
        }
        return InProcessor.apply((Object)this.value().fold(), this.list().stream().map(Expression::fold).toList());
    }

    protected boolean areCompatible(DataType left, DataType right) {
        if (left == DataTypes.UNSIGNED_LONG || right == DataTypes.UNSIGNED_LONG) {
            return left == right;
        }
        return EsqlDataTypes.areCompatible(left, right);
    }

    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = EsqlTypeResolutions.isExact(this.value(), this.functionName(), TypeResolutions.ParamOrdinal.DEFAULT);
        if (resolution.unresolved()) {
            return resolution;
        }
        DataType dt = this.value().dataType();
        for (int i = 0; i < this.list().size(); ++i) {
            Expression listValue = (Expression)this.list().get(i);
            if (this.areCompatible(dt, listValue.dataType())) continue;
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"{} argument of [{}] must be [{}], found value [{}] type [{}]", (Object[])new Object[]{StringUtils.ordinal((int)(i + 1)), this.sourceText(), dt.typeName(), Expressions.name((Expression)listValue), listValue.dataType().typeName()}));
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }
}

