/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.ModUnsignedLongsEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Mod
extends EsqlArithmeticOperation {
    public Mod(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.MOD, ModIntsEvaluator.Factory::new, ModLongsEvaluator.Factory::new, ModUnsignedLongsEvaluator.Factory::new, (s, lhs, rhs) -> new ModDoublesEvaluator.Factory(source, lhs, rhs));
    }

    protected NodeInfo<Mod> info() {
        return NodeInfo.create((Node)this, Mod::new, (Object)this.left(), (Object)this.right());
    }

    protected Mod replaceChildren(Expression left, Expression right) {
        return new Mod(this.source(), left, right);
    }

    static int processInts(int lhs, int rhs) {
        if (rhs == 0) {
            throw new ArithmeticException("/ by zero");
        }
        return lhs % rhs;
    }

    static long processLongs(long lhs, long rhs) {
        if (rhs == 0L) {
            throw new ArithmeticException("/ by zero");
        }
        return lhs % rhs;
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        if (rhs == NumericUtils.ZERO_AS_UNSIGNED_LONG) {
            throw new ArithmeticException("/ by zero");
        }
        return EsqlDataTypeConverter.longToUnsignedLong(Long.remainderUnsigned(EsqlDataTypeConverter.longToUnsignedLong(lhs, true), EsqlDataTypeConverter.longToUnsignedLong(rhs, true)), true);
    }

    static double processDoubles(double lhs, double rhs) {
        double value = lhs % rhs;
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new ArithmeticException("/ by zero");
        }
        return value;
    }
}

