/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.ExceptionUtils;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

abstract class DateTimeArithmeticOperation
extends EsqlArithmeticOperation {
    private final DatetimeArithmeticEvaluator datetimes;

    DateTimeArithmeticOperation(Source source, Expression left, Expression right, EsqlArithmeticOperation.OperationSymbol op, EsqlArithmeticOperation.BinaryEvaluator ints, EsqlArithmeticOperation.BinaryEvaluator longs, EsqlArithmeticOperation.BinaryEvaluator ulongs, EsqlArithmeticOperation.BinaryEvaluator doubles, DatetimeArithmeticEvaluator datetimes) {
        super(source, left, right, op, ints, longs, ulongs, doubles);
        this.datetimes = datetimes;
    }

    protected Expression.TypeResolution resolveInputType(Expression e, TypeResolutions.ParamOrdinal paramOrdinal) {
        return TypeResolutions.isType((Expression)e, t -> t.isNumeric() || EsqlDataTypes.isDateTimeOrTemporal(t) || DataTypes.isNull((DataType)t), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)paramOrdinal, (String[])new String[]{"datetime", "numeric"});
    }

    @Override
    protected Expression.TypeResolution checkCompatibility() {
        DataType leftType = this.left().dataType();
        DataType rightType = this.right().dataType();
        if (EsqlDataTypes.isDateTimeOrTemporal(leftType) || EsqlDataTypes.isDateTimeOrTemporal(rightType)) {
            if (DataTypes.isNull((DataType)leftType) || DataTypes.isNull((DataType)rightType)) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            if (DataTypes.isDateTime((DataType)leftType) && EsqlDataTypes.isTemporalAmount(rightType) || EsqlDataTypes.isTemporalAmount(leftType) && DataTypes.isDateTime((DataType)rightType)) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            if (EsqlDataTypes.isTemporalAmount(leftType) && EsqlDataTypes.isTemporalAmount(rightType) && leftType == rightType) {
                return Expression.TypeResolution.TYPE_RESOLVED;
            }
            return new Expression.TypeResolution(DateTimeArithmeticOperation.formatIncompatibleTypesMessage(this.symbol(), leftType, rightType));
        }
        return super.checkCompatibility();
    }

    abstract Period fold(Period var1, Period var2);

    abstract Duration fold(Duration var1, Duration var2);

    @Override
    public final Object fold() {
        DataType leftDataType = this.left().dataType();
        DataType rightDataType = this.right().dataType();
        if (leftDataType == EsqlDataTypes.DATE_PERIOD && rightDataType == EsqlDataTypes.DATE_PERIOD) {
            Object l = this.left().fold();
            Object r = this.right().fold();
            if (l instanceof Collection || r instanceof Collection) {
                return null;
            }
            try {
                return this.fold((Period)l, (Period)r);
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (leftDataType == EsqlDataTypes.TIME_DURATION && rightDataType == EsqlDataTypes.TIME_DURATION) {
            Duration l = (Duration)this.left().fold();
            Duration r = (Duration)this.right().fold();
            try {
                return this.fold(l, r);
            }
            catch (ArithmeticException e) {
                throw ExceptionUtils.math(this.source(), e);
            }
        }
        if (DataTypes.isNull((DataType)leftDataType) || DataTypes.isNull((DataType)rightDataType)) {
            return null;
        }
        return super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        if (this.dataType() == DataTypes.DATETIME) {
            Expression temporalAmountArgument;
            Expression datetimeArgument;
            if (this.left().dataType() == DataTypes.DATETIME) {
                datetimeArgument = this.left();
                temporalAmountArgument = this.right();
            } else {
                datetimeArgument = this.right();
                temporalAmountArgument = this.left();
            }
            return this.datetimes.apply(this.source(), toEvaluator.apply(datetimeArgument), (TemporalAmount)temporalAmountArgument.fold());
        }
        return super.toEvaluator(toEvaluator);
    }

    static interface DatetimeArithmeticEvaluator {
        public EvalOperator.ExpressionEvaluator.Factory apply(Source var1, EvalOperator.ExpressionEvaluator.Factory var2, TemporalAmount var3);
    }
}

