/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.ToLowerEvaluator;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public class ToLower
extends EsqlConfigurationFunction {
    private final Expression field;

    @FunctionInfo(returnType={"keyword", "text"}, description="Returns a new string representing the input string converted to lower case.")
    public ToLower(Source source, @Param(name="str", type={"keyword", "text"}, description="The input string") Expression field, Configuration configuration) {
        super(source, List.of(field), configuration);
        this.field = field;
    }

    public DataType dataType() {
        return this.field.dataType();
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public boolean foldable() {
        return this.field.foldable();
    }

    static BytesRef process(BytesRef val, Locale locale) {
        return BytesRefs.toBytesRef((Object)val.utf8ToString().toLowerCase(locale));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        return new ToLowerEvaluator.Factory(this.source(), fieldEvaluator, ((EsqlConfiguration)this.configuration()).locale());
    }

    public Expression field() {
        return this.field;
    }

    public ToLower replaceChild(Expression child) {
        return new ToLower(this.source(), child, this.configuration());
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        assert (newChildren.size() == 1);
        return this.replaceChild(newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToLower::new, (Object)this.field, (Object)this.configuration());
    }
}

