/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SubstringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.SubstringNoLengthEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Substring
extends EsqlScalarFunction
implements OptionalArgument {
    private final Expression str;
    private final Expression start;
    private final Expression length;

    @FunctionInfo(returnType={"keyword"}, description="Returns a substring of a string, specified by a start position and an optional length")
    public Substring(Source source, @Param(name="string", type={"keyword", "text"}) Expression str, @Param(name="start", type={"integer"}) Expression start, @Param(optional=true, name="length", type={"integer"}) Expression length) {
        super(source, length == null ? Arrays.asList(str, start) : Arrays.asList(str, start, length));
        this.str = str;
        this.start = start;
        this.length = length;
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isString((Expression)this.str, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isType((Expression)this.start, dt -> dt == DataTypes.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{"integer"});
        if (resolution.unresolved()) {
            return resolution;
        }
        return this.length == null ? Expression.TypeResolution.TYPE_RESOLVED : TypeResolutions.isType((Expression)this.length, dt -> dt == DataTypes.INTEGER, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD, (String[])new String[]{"integer"});
    }

    public boolean foldable() {
        return this.str.foldable() && this.start.foldable() && (this.length == null || this.length.foldable());
    }

    static BytesRef process(BytesRef str, int start) {
        int length = str.length;
        return Substring.process(str, start, length);
    }

    static BytesRef process(BytesRef str, int start, int length) {
        if (str.length == 0) {
            return null;
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length parameter cannot be negative, found [" + length + "]");
        }
        int codePointCount = UnicodeUtil.codePointCount((BytesRef)str);
        int indexStart = Substring.indexStart(codePointCount, start);
        int indexEnd = Math.min(codePointCount, indexStart + length);
        String s = str.utf8ToString();
        return new BytesRef((CharSequence)s.substring(s.offsetByCodePoints(0, indexStart), s.offsetByCodePoints(0, indexEnd)));
    }

    private static int indexStart(int codePointCount, int start) {
        int indexStart = start > 0 ? start - 1 : (start < 0 ? codePointCount + start : start);
        return Math.min(Math.max(0, indexStart), codePointCount);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Substring(this.source(), newChildren.get(0), newChildren.get(1), this.length == null ? null : newChildren.get(2));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Substring::new, (Object)this.str, (Object)this.start, (Object)this.length);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory strFactory = toEvaluator.apply(this.str);
        EvalOperator.ExpressionEvaluator.Factory startFactory = toEvaluator.apply(this.start);
        if (this.length == null) {
            return new SubstringNoLengthEvaluator.Factory(this.source(), strFactory, startFactory);
        }
        EvalOperator.ExpressionEvaluator.Factory lengthFactory = toEvaluator.apply(this.length);
        return new SubstringEvaluator.Factory(this.source(), strFactory, startFactory, lengthFactory);
    }
}

