/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.ByteRunAutomaton;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.AutomataMatch;
import org.elasticsearch.xpack.ql.tree.Source;

public final class AutomataMatchEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator input;
    private final ByteRunAutomaton automaton;
    private final String pattern;
    private final DriverContext driverContext;

    public AutomataMatchEvaluator(Source source, EvalOperator.ExpressionEvaluator input, ByteRunAutomaton automaton, String pattern, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.input = input;
        this.automaton = automaton;
        this.pattern = pattern;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock inputBlock = (BytesRefBlock)this.input.eval(page);){
            BytesRefVector inputVector = inputBlock.asVector();
            if (inputVector == null) {
                BooleanBlock booleanBlock = this.eval(page.getPositionCount(), inputBlock);
                return booleanBlock;
            }
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), inputVector).asBlock();
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock inputBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (inputBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (inputBlock.getValueCount(p) != 1) {
                    if (inputBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendBoolean(AutomataMatch.process(inputBlock.getBytesRef(inputBlock.getFirstValueIndex(p), inputScratch), this.automaton, this.pattern));
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanVector eval(int positionCount, BytesRefVector inputVector) {
        try (BooleanVector.Builder result = this.driverContext.blockFactory().newBooleanVectorBuilder(positionCount);){
            BytesRef inputScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                result.appendBoolean(AutomataMatch.process(inputVector.getBytesRef(p, inputScratch), this.automaton, this.pattern));
            }
            BooleanVector booleanVector = result.build();
            return booleanVector;
        }
    }

    public String toString() {
        return "AutomataMatchEvaluator[input=" + this.input + ", pattern=" + this.pattern + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.input);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory input;
        private final ByteRunAutomaton automaton;
        private final String pattern;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory input, ByteRunAutomaton automaton, String pattern) {
            this.source = source;
            this.input = input;
            this.automaton = automaton;
            this.pattern = pattern;
        }

        public AutomataMatchEvaluator get(DriverContext context) {
            return new AutomataMatchEvaluator(this.source, this.input.get(context), this.automaton, this.pattern, context);
        }

        public String toString() {
            return "AutomataMatchEvaluator[input=" + this.input + ", pattern=" + this.pattern + "]";
        }
    }
}

