/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.common.geo.Orientation;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.GeoShapeIndexer;
import org.elasticsearch.index.mapper.ShapeIndexer;
import org.elasticsearch.lucene.spatial.CartesianShapeIndexer;
import org.elasticsearch.lucene.spatial.CoordinateEncoder;
import org.elasticsearch.lucene.spatial.GeometryDocValueReader;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialContains;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialEvaluatorFactory;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinCartesianPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinCartesianPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinCartesianSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinCartesianSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinGeoPointDocValuesAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinGeoPointDocValuesAndSourceEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinGeoSourceAndConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialWithinGeoSourceAndSourceEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.util.SpatialCoordinateTypes;

public class SpatialWithin
extends SpatialRelatesFunction
implements SurrogateExpression {
    public static final SpatialRelatesFunction.SpatialRelations GEO = new SpatialRelatesFunction.SpatialRelations(ShapeField.QueryRelation.WITHIN, SpatialCoordinateTypes.GEO, CoordinateEncoder.GEO, (ShapeIndexer)new GeoShapeIndexer(Orientation.CCW, "ST_Within"));
    public static final SpatialRelatesFunction.SpatialRelations CARTESIAN = new SpatialRelatesFunction.SpatialRelations(ShapeField.QueryRelation.WITHIN, SpatialCoordinateTypes.CARTESIAN, CoordinateEncoder.CARTESIAN, (ShapeIndexer)new CartesianShapeIndexer("ST_Within"));
    private static final Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorMap = new HashMap();

    @FunctionInfo(returnType={"boolean"}, description="Returns whether the first geometry is within the second geometry.", examples={@Example(file="spatial_shapes", tag="st_within-airport_city_boundaries")})
    public SpatialWithin(Source source, @Param(name="geomA", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Geometry column name or variable of geometry type") Expression left, @Param(name="geomB", type={"geo_point", "cartesian_point", "geo_shape", "cartesian_shape"}, description="Geometry column name or variable of geometry type") Expression right) {
        this(source, left, right, false, false);
    }

    SpatialWithin(Source source, Expression left, Expression right, boolean leftDocValues, boolean rightDocValues) {
        super(source, left, right, leftDocValues, rightDocValues);
    }

    @Override
    public ShapeField.QueryRelation queryRelation() {
        return ShapeField.QueryRelation.WITHIN;
    }

    @Override
    public SpatialWithin withDocValues(Set<FieldAttribute> attributes) {
        boolean leftDV = this.leftDocValues || this.foundField(this.left(), attributes);
        boolean rightDV = this.rightDocValues || this.foundField(this.right(), attributes);
        return new SpatialWithin(this.source(), this.left(), this.right(), leftDV, rightDV);
    }

    protected SpatialWithin replaceChildren(Expression newLeft, Expression newRight) {
        return new SpatialWithin(this.source(), newLeft, newRight, this.leftDocValues, this.rightDocValues);
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, SpatialWithin::new, (Object)this.left(), (Object)this.right());
    }

    @Override
    public Object fold() {
        try {
            GeometryDocValueReader docValueReader = SpatialRelatesUtils.asGeometryDocValueReader(this.crsType, this.left());
            Component2D component2D = SpatialRelatesUtils.asLuceneComponent2D(this.crsType, this.right());
            return this.crsType == SpatialRelatesFunction.SpatialCrsType.GEO ? GEO.geometryRelatesGeometry(docValueReader, component2D) : CARTESIAN.geometryRelatesGeometry(docValueReader, component2D);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to fold constant fields: " + e.getMessage(), e);
        }
    }

    @Override
    Map<SpatialEvaluatorFactory.SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules() {
        return evaluatorMap;
    }

    @Override
    public SpatialRelatesFunction surrogate() {
        if (this.left().foldable() && !this.right().foldable()) {
            return new SpatialContains(this.source(), this.right(), this.left(), this.rightDocValues, this.leftDocValues);
        }
        return this;
    }

    static boolean processGeoSourceAndConstant(BytesRef leftValue, Component2D rightValue) throws IOException {
        return GEO.geometryRelatesGeometry(leftValue, rightValue);
    }

    static boolean processGeoSourceAndSource(BytesRef leftValue, BytesRef rightValue) throws IOException {
        return GEO.geometryRelatesGeometry(leftValue, rightValue);
    }

    static boolean processGeoPointDocValuesAndConstant(long leftValue, Component2D rightValue) {
        return GEO.pointRelatesGeometry(leftValue, rightValue);
    }

    static boolean processGeoPointDocValuesAndSource(long leftValue, BytesRef rightValue) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(rightValue);
        return GEO.pointRelatesGeometry(leftValue, geometry);
    }

    static boolean processCartesianSourceAndConstant(BytesRef leftValue, Component2D rightValue) throws IOException {
        return CARTESIAN.geometryRelatesGeometry(leftValue, rightValue);
    }

    static boolean processCartesianSourceAndSource(BytesRef leftValue, BytesRef rightValue) throws IOException {
        return CARTESIAN.geometryRelatesGeometry(leftValue, rightValue);
    }

    static boolean processCartesianPointDocValuesAndConstant(long leftValue, Component2D rightValue) {
        return CARTESIAN.pointRelatesGeometry(leftValue, rightValue);
    }

    static boolean processCartesianPointDocValuesAndSource(long leftValue, BytesRef rightValue) {
        Geometry geometry = SpatialCoordinateTypes.UNSPECIFIED.wkbToGeometry(rightValue);
        return CARTESIAN.pointRelatesGeometry(leftValue, geometry);
    }

    static {
        for (DataType spatialType : new DataType[]{EsqlDataTypes.GEO_POINT, EsqlDataTypes.GEO_SHAPE}) {
            for (DataType otherType : new DataType[]{EsqlDataTypes.GEO_POINT, EsqlDataTypes.GEO_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinGeoSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinGeoSourceAndConstantEvaluator.Factory::new)));
                if (!EsqlDataTypes.isSpatialPoint(spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinGeoPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinGeoPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
        for (DataType spatialType : new DataType[]{EsqlDataTypes.CARTESIAN_POINT, EsqlDataTypes.CARTESIAN_SHAPE}) {
            for (DataType otherType : new DataType[]{EsqlDataTypes.CARTESIAN_POINT, EsqlDataTypes.CARTESIAN_SHAPE}) {
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinCartesianSourceAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinCartesianSourceAndConstantEvaluator.Factory::new)));
                if (!EsqlDataTypes.isSpatialPoint(spatialType)) continue;
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSources(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorFactoryWithFields((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinCartesianPointDocValuesAndSourceEvaluator.Factory::new)));
                evaluatorMap.put(SpatialEvaluatorFactory.SpatialEvaluatorKey.fromSourceAndConstant(spatialType, otherType).withLeftDocValues(), new SpatialEvaluatorFactory.SpatialEvaluatorWithConstantFactory((TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory>)((TriFunction)SpatialWithinCartesianPointDocValuesAndConstantEvaluator.Factory::new)));
            }
        }
    }
}

