/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.io.IOException;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialIntersects;
import org.elasticsearch.xpack.ql.tree.Source;

public final class SpatialIntersectsCartesianSourceAndConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator leftValue;
    private final Component2D rightValue;
    private final DriverContext driverContext;

    public SpatialIntersectsCartesianSourceAndConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator leftValue, Component2D rightValue, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (BytesRefBlock leftValueBlock = (BytesRefBlock)this.leftValue.eval(page);){
            BytesRefVector leftValueVector = leftValueBlock.asVector();
            if (leftValueVector == null) {
                BooleanBlock booleanBlock = this.eval(page.getPositionCount(), leftValueBlock);
                return booleanBlock;
            }
            BooleanBlock booleanBlock = this.eval(page.getPositionCount(), leftValueVector);
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefBlock leftValueBlock) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef leftValueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                if (leftValueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (leftValueBlock.getValueCount(p) != 1) {
                    if (leftValueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                try {
                    result.appendBoolean(SpatialIntersects.processCartesianSourceAndConstant(leftValueBlock.getBytesRef(leftValueBlock.getFirstValueIndex(p), leftValueScratch), this.rightValue));
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public BooleanBlock eval(int positionCount, BytesRefVector leftValueVector) {
        try (BooleanBlock.Builder result = this.driverContext.blockFactory().newBooleanBlockBuilder(positionCount);){
            BytesRef leftValueScratch = new BytesRef();
            for (int p = 0; p < positionCount; ++p) {
                try {
                    result.appendBoolean(SpatialIntersects.processCartesianSourceAndConstant(leftValueVector.getBytesRef(p, leftValueScratch), this.rightValue));
                    continue;
                }
                catch (IOException | IllegalArgumentException e) {
                    this.warnings.registerException(e);
                    result.appendNull();
                }
            }
            BooleanBlock booleanBlock = result.build();
            return booleanBlock;
        }
    }

    public String toString() {
        return "SpatialIntersectsCartesianSourceAndConstantEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.leftValue);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory leftValue;
        private final Component2D rightValue;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory leftValue, Component2D rightValue) {
            this.source = source;
            this.leftValue = leftValue;
            this.rightValue = rightValue;
        }

        public SpatialIntersectsCartesianSourceAndConstantEvaluator get(DriverContext context) {
            return new SpatialIntersectsCartesianSourceAndConstantEvaluator(this.source, this.leftValue.get(context), this.rightValue, context);
        }

        public String toString() {
            return "SpatialIntersectsCartesianSourceAndConstantEvaluator[leftValue=" + this.leftValue + ", rightValue=" + this.rightValue + "]";
        }
    }
}

