/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.spatial;

import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.geo.Component2D;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.SpatialRelatesUtils;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

abstract class SpatialEvaluatorFactory<V, T> {
    protected final TriFunction<Source, V, T, EvalOperator.ExpressionEvaluator.Factory> factoryCreator;

    SpatialEvaluatorFactory(TriFunction<Source, V, T, EvalOperator.ExpressionEvaluator.Factory> factoryCreator) {
        this.factoryCreator = factoryCreator;
    }

    public abstract EvalOperator.ExpressionEvaluator.Factory get(SpatialSourceSupplier var1, Function<Expression, EvalOperator.ExpressionEvaluator.Factory> var2);

    static EvalOperator.ExpressionEvaluator.Factory makeSpatialEvaluator(SpatialSourceSupplier s, Map<SpatialEvaluatorKey, SpatialEvaluatorFactory<?, ?>> evaluatorRules, Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        SpatialEvaluatorKey evaluatorKey = new SpatialEvaluatorKey(s.crsType(), s.leftDocValues(), s.rightDocValues(), SpatialEvaluatorFactory.fieldKey(s.left()), SpatialEvaluatorFactory.fieldKey(s.right()));
        SpatialEvaluatorFactory<?, ?> factory = evaluatorRules.get(evaluatorKey);
        if (factory == null) {
            factory = evaluatorRules.get(evaluatorKey = evaluatorKey.swapSides());
            if (factory == null) {
                throw evaluatorKey.unsupported();
            }
            return factory.get(new SwappedSpatialSourceSupplier(s), toEvaluator);
        }
        return factory.get(s, toEvaluator);
    }

    protected static SpatialEvaluatorFieldKey fieldKey(Expression expression) {
        return new SpatialEvaluatorFieldKey(expression.dataType(), expression.foldable());
    }

    record SpatialEvaluatorKey(SpatialRelatesFunction.SpatialCrsType crsType, boolean leftDocValues, boolean rightDocValues, SpatialEvaluatorFieldKey left, SpatialEvaluatorFieldKey right) {
        SpatialEvaluatorKey(SpatialRelatesFunction.SpatialCrsType crsType, SpatialEvaluatorFieldKey left, SpatialEvaluatorFieldKey right) {
            this(crsType, false, false, left, right);
        }

        SpatialEvaluatorKey withLeftDocValues() {
            return new SpatialEvaluatorKey(this.crsType, true, false, this.left, this.right);
        }

        SpatialEvaluatorKey swapSides() {
            return new SpatialEvaluatorKey(this.crsType, this.rightDocValues, this.leftDocValues, this.right, this.left);
        }

        static SpatialEvaluatorKey fromSourceAndConstant(DataType left, DataType right) {
            return new SpatialEvaluatorKey(SpatialRelatesFunction.SpatialCrsType.fromDataType(left), new SpatialEvaluatorFieldKey(left, false), new SpatialEvaluatorFieldKey(right, true));
        }

        static SpatialEvaluatorKey fromSources(DataType left, DataType right) {
            return new SpatialEvaluatorKey(SpatialRelatesFunction.SpatialCrsType.fromDataType(left), new SpatialEvaluatorFieldKey(left, false), new SpatialEvaluatorFieldKey(right, false));
        }

        UnsupportedOperationException unsupported() {
            return new UnsupportedOperationException("Unsupported spatial relation combination: " + this);
        }
    }

    static interface SpatialSourceSupplier {
        public Source source();

        public Expression left();

        public Expression right();

        public SpatialRelatesFunction.SpatialCrsType crsType();

        public boolean leftDocValues();

        public boolean rightDocValues();
    }

    protected record SpatialEvaluatorFieldKey(DataType dataType, boolean isConstant) {
    }

    protected static class SwappedSpatialSourceSupplier
    implements SpatialSourceSupplier {
        private final SpatialSourceSupplier delegate;

        public SwappedSpatialSourceSupplier(SpatialSourceSupplier delegate) {
            this.delegate = delegate;
        }

        @Override
        public Source source() {
            return this.delegate.source();
        }

        @Override
        public SpatialRelatesFunction.SpatialCrsType crsType() {
            return this.delegate.crsType();
        }

        @Override
        public boolean leftDocValues() {
            return this.delegate.leftDocValues();
        }

        @Override
        public boolean rightDocValues() {
            return this.delegate.rightDocValues();
        }

        @Override
        public Expression left() {
            return this.delegate.right();
        }

        @Override
        public Expression right() {
            return this.delegate.left();
        }
    }

    protected static class SpatialEvaluatorWithConstantArrayFactory
    extends SpatialEvaluatorFactory<EvalOperator.ExpressionEvaluator.Factory, Component2D[]> {
        SpatialEvaluatorWithConstantArrayFactory(TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D[], EvalOperator.ExpressionEvaluator.Factory> factoryCreator) {
            super(factoryCreator);
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory get(SpatialSourceSupplier s, Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.factoryCreator.apply((Object)s.source(), (Object)toEvaluator.apply(s.left()), (Object)SpatialRelatesUtils.asLuceneComponent2Ds(s.crsType(), s.right()));
        }
    }

    protected static class SpatialEvaluatorWithConstantFactory
    extends SpatialEvaluatorFactory<EvalOperator.ExpressionEvaluator.Factory, Component2D> {
        SpatialEvaluatorWithConstantFactory(TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, Component2D, EvalOperator.ExpressionEvaluator.Factory> factoryCreator) {
            super(factoryCreator);
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory get(SpatialSourceSupplier s, Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.factoryCreator.apply((Object)s.source(), (Object)toEvaluator.apply(s.left()), (Object)SpatialRelatesUtils.asLuceneComponent2D(s.crsType(), s.right()));
        }
    }

    protected static class SpatialEvaluatorFactoryWithFields
    extends SpatialEvaluatorFactory<EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> {
        SpatialEvaluatorFactoryWithFields(TriFunction<Source, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory, EvalOperator.ExpressionEvaluator.Factory> factoryCreator) {
            super(factoryCreator);
        }

        @Override
        public EvalOperator.ExpressionEvaluator.Factory get(SpatialSourceSupplier s, Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
            return (EvalOperator.ExpressionEvaluator.Factory)this.factoryCreator.apply((Object)s.source(), (Object)toEvaluator.apply(s.left()), (Object)toEvaluator.apply(s.right()));
        }
    }
}

