/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;

public final class MvMaxIntEvaluator
extends AbstractMultivalueFunction.AbstractEvaluator {
    public MvMaxIntEvaluator(EvalOperator.ExpressionEvaluator field, DriverContext driverContext) {
        super(driverContext, field);
    }

    @Override
    public String name() {
        return "MvMax";
    }

    @Override
    public Block evalNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNullable(fieldVal);
        }
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                int value = v.getInt(first);
                for (int i = first + 1; i < end; ++i) {
                    int next = v.getInt(i);
                    value = MvMax.process(value, next);
                }
                int result = value;
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    @Override
    public Block evalNotNullable(Block fieldVal) {
        if (fieldVal.mvSortedAscending()) {
            return this.evalAscendingNotNullable(fieldVal);
        }
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int end = first + valueCount;
                int value = v.getInt(first);
                for (int i = first + 1; i < end; ++i) {
                    int next = v.getInt(i);
                    value = MvMax.process(value, next);
                }
                int result = value;
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    private Block evalAscendingNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntBlock.Builder builder = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                if (valueCount == 0) {
                    builder.appendNull();
                    continue;
                }
                int first = v.getFirstValueIndex(p);
                int idx = MvMax.ascendingIndex(valueCount);
                int result = v.getInt(first + idx);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build();
            return intBlock;
        }
    }

    private Block evalAscendingNotNullable(Block fieldVal) {
        IntBlock v = (IntBlock)fieldVal;
        int positionCount = v.getPositionCount();
        try (IntVector.FixedBuilder builder = this.driverContext.blockFactory().newIntVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = v.getValueCount(p);
                int first = v.getFirstValueIndex(p);
                int idx = MvMax.ascendingIndex(valueCount);
                int result = v.getInt(first + idx);
                builder.appendInt(result);
            }
            IntBlock intBlock = builder.build().asBlock();
            return intBlock;
        }
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field) {
            this.field = field;
        }

        public MvMaxIntEvaluator get(DriverContext context) {
            return new MvMaxIntEvaluator(this.field.get(context), context);
        }

        public String toString() {
            return "MvMax[field=" + this.field + "]";
        }
    }
}

