/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.multivalue;

import java.util.List;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.AbstractMultivalueFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvgUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class MvAvg
extends AbstractMultivalueFunction {
    @FunctionInfo(returnType={"double"}, description="Converts a multivalued field into a single valued field containing the average of all of the values.")
    public MvAvg(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Expression.TypeResolution resolveFieldType() {
        return TypeResolutions.isType((Expression)this.field(), t -> t.isNumeric() && EsqlDataTypes.isRepresentable(t), (String)this.sourceText(), null, (String[])new String[]{"numeric"});
    }

    @Override
    public DataType dataType() {
        return DataTypes.DOUBLE;
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        return switch (PlannerUtils.toElementType(this.field().dataType())) {
            case ElementType.DOUBLE -> new MvAvgDoubleEvaluator.Factory(fieldEval);
            case ElementType.INT -> new MvAvgIntEvaluator.Factory(fieldEval);
            case ElementType.LONG -> {
                if (this.field().dataType() == DataTypes.UNSIGNED_LONG) {
                    yield new MvAvgUnsignedLongEvaluator.Factory(fieldEval);
                }
                yield new MvAvgLongEvaluator.Factory(fieldEval);
            }
            case ElementType.NULL -> EvalOperator.CONSTANT_NULL_FACTORY;
            default -> throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
        };
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new MvAvg(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, MvAvg::new, (Object)this.field());
    }

    public static void process(CompensatedSum sum, double v) {
        sum.add(v);
    }

    public static double finish(CompensatedSum sum, int valueCount) {
        double value = sum.value();
        sum.reset(0.0, 0.0);
        return value / (double)valueCount;
    }

    static void process(CompensatedSum sum, int v) {
        sum.add((double)v);
    }

    static double single(int value) {
        return value;
    }

    static void process(CompensatedSum sum, long v) {
        sum.add((double)v);
    }

    static double single(long value) {
        return value;
    }

    static void processUnsignedLong(CompensatedSum sum, long v) {
        sum.add(EsqlDataTypeConverter.unsignedLongToDouble(v));
    }

    static double singleUnsignedLong(long value) {
        return EsqlDataTypeConverter.unsignedLongToDouble(value);
    }
}

