/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbstractTrigonometricFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AsinEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Asin
extends AbstractTrigonometricFunction {
    @FunctionInfo(returnType={"double"}, description="Returns the {wikipedia}/Inverse_trigonometric_functions[arcsine] of the input\nnumeric expression as an angle, expressed in radians.", examples={@Example(file="floats", tag="asin")})
    public Asin(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Number between -1 and 1. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    @Override
    protected EvalOperator.ExpressionEvaluator.Factory doubleEvaluator(EvalOperator.ExpressionEvaluator.Factory field) {
        return new AsinEvaluator.Factory(this.source(), field);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Asin(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Asin::new, (Object)this.field());
    }

    static double process(double val) {
        if (Math.abs(val) > 1.0) {
            throw new ArithmeticException("Asin input out of range");
        }
        return Math.asin(val);
    }
}

