/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AbsLongEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Abs
extends UnaryScalarFunction {
    @FunctionInfo(returnType={"double", "integer", "long", "unsigned_long"}, description="Returns the absolute value.", examples={@Example(file="math", tag="abs"), @Example(file="math", tag="abs-employees")})
    public Abs(Source source, @Param(name="number", type={"double", "integer", "long", "unsigned_long"}, description="Numeric expression. If `null`, the function returns `null`.") Expression n) {
        super(source, n);
    }

    static double process(double fieldVal) {
        return Math.abs(fieldVal);
    }

    static long process(long fieldVal) {
        return Math.absExact(fieldVal);
    }

    static int process(int fieldVal) {
        return Math.absExact(fieldVal);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory field = toEvaluator.apply(this.field());
        if (this.dataType() == DataTypes.DOUBLE) {
            return new AbsDoubleEvaluator.Factory(this.source(), field);
        }
        if (this.dataType() == DataTypes.UNSIGNED_LONG) {
            return field;
        }
        if (this.dataType() == DataTypes.LONG) {
            return new AbsLongEvaluator.Factory(this.source(), field);
        }
        if (this.dataType() == DataTypes.INTEGER) {
            return new AbsIntEvaluator.Factory(this.source(), field);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.dataType());
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new Abs(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Abs::new, (Object)this.field());
    }
}

