/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.Now;
import org.elasticsearch.xpack.ql.tree.Source;

public final class NowEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final long now;
    private final DriverContext driverContext;

    public NowEvaluator(Source source, long now, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.now = now;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        return this.eval(page.getPositionCount()).asBlock();
    }

    public LongVector eval(int positionCount) {
        try (LongVector.Builder result = this.driverContext.blockFactory().newLongVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(Now.process(this.now));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "NowEvaluator[now=" + this.now + "]";
    }

    public void close() {
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final long now;

        public Factory(Source source, long now) {
            this.source = source;
            this.now = now;
        }

        public NowEvaluator get(DriverContext context) {
            return new NowEvaluator(this.source, this.now, context);
        }

        public String toString() {
            return "NowEvaluator[now=" + this.now + "]";
        }
    }
}

