/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormatEvaluator;
import org.elasticsearch.xpack.esql.session.EsqlConfiguration;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class DateFormat
extends EsqlConfigurationFunction
implements OptionalArgument {
    private final Expression field;
    private final Expression format;

    @FunctionInfo(returnType={"keyword"}, description="Returns a string representation of a date, in the provided format.")
    public DateFormat(Source source, @Param(optional=true, name="dateFormat", type={"keyword", "text"}, description="A valid date pattern") Expression format, @Param(name="date", type={"date"}, description="Date expression") Expression date, Configuration configuration) {
        super(source, date != null ? List.of(format, date) : List.of(format), configuration);
        this.field = date != null ? date : format;
        this.format = date != null ? format : null;
    }

    public DataType dataType() {
        return DataTypes.KEYWORD;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isDate((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)(this.format == null ? TypeResolutions.ParamOrdinal.FIRST : TypeResolutions.ParamOrdinal.SECOND));
        if (resolution.unresolved()) {
            return resolution;
        }
        if (this.format != null && (resolution = EsqlTypeResolutions.isStringAndExact(this.format, this.sourceText(), TypeResolutions.ParamOrdinal.FIRST)).unresolved()) {
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public boolean foldable() {
        return this.field.foldable() && (this.format == null || this.format.foldable());
    }

    static BytesRef process(long val, DateFormatter formatter) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.dateTimeToString(val, formatter));
    }

    static BytesRef process(long val, BytesRef formatter, Locale locale) {
        return new BytesRef((CharSequence)EsqlDataTypeConverter.dateTimeToString(val, DateFormat.toFormatter(formatter, locale)));
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply(this.field);
        if (this.format == null) {
            return new DateFormatConstantEvaluator.Factory(this.source(), fieldEvaluator, EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER);
        }
        if (!EsqlDataTypes.isString(this.format.dataType())) {
            throw new IllegalArgumentException("unsupported data type for format [" + this.format.dataType() + "]");
        }
        if (this.format.foldable()) {
            DateFormatter formatter = DateFormat.toFormatter(this.format.fold(), ((EsqlConfiguration)this.configuration()).locale());
            return new DateFormatConstantEvaluator.Factory(this.source(), fieldEvaluator, formatter);
        }
        EvalOperator.ExpressionEvaluator.Factory formatEvaluator = toEvaluator.apply(this.format);
        return new DateFormatEvaluator.Factory(this.source(), fieldEvaluator, formatEvaluator, ((EsqlConfiguration)this.configuration()).locale());
    }

    private static DateFormatter toFormatter(Object format, Locale locale) {
        DateFormatter result = format == null ? EsqlDataTypeConverter.DEFAULT_DATE_TIME_FORMATTER : DateFormatter.forPattern((String)((BytesRef)format).utf8ToString());
        return result.withLocale(locale);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateFormat(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null, this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        Expression first = this.format != null ? this.format : this.field;
        Expression second = this.format != null ? this.field : null;
        return NodeInfo.create((Node)this, DateFormat::new, (Object)first, (Object)second, (Object)this.configuration());
    }
}

