/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;
import org.elasticsearch.xpack.ql.tree.Source;

public final class DateExtractConstantEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator value;
    private final ChronoField chronoField;
    private final ZoneId zone;
    private final DriverContext driverContext;

    public DateExtractConstantEvaluator(Source source, EvalOperator.ExpressionEvaluator value, ChronoField chronoField, ZoneId zone, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.value = value;
        this.chronoField = chronoField;
        this.zone = zone;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock valueBlock = (LongBlock)this.value.eval(page);){
            LongVector valueVector = valueBlock.asVector();
            if (valueVector == null) {
                LongBlock longBlock = this.eval(page.getPositionCount(), valueBlock);
                return longBlock;
            }
            LongBlock longBlock = this.eval(page.getPositionCount(), valueVector).asBlock();
            return longBlock;
        }
    }

    public LongBlock eval(int positionCount, LongBlock valueBlock) {
        try (LongBlock.Builder result = this.driverContext.blockFactory().newLongBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (valueBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (valueBlock.getValueCount(p) != 1) {
                    if (valueBlock.getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendLong(DateExtract.process(valueBlock.getLong(valueBlock.getFirstValueIndex(p)), this.chronoField, this.zone));
            }
            LongBlock longBlock = result.build();
            return longBlock;
        }
    }

    public LongVector eval(int positionCount, LongVector valueVector) {
        try (LongVector.Builder result = this.driverContext.blockFactory().newLongVectorBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendLong(DateExtract.process(valueVector.getLong(p), this.chronoField, this.zone));
            }
            LongVector longVector = result.build();
            return longVector;
        }
    }

    public String toString() {
        return "DateExtractConstantEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.value);
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory value;
        private final ChronoField chronoField;
        private final ZoneId zone;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory value, ChronoField chronoField, ZoneId zone) {
            this.source = source;
            this.value = value;
            this.chronoField = chronoField;
            this.zone = zone;
        }

        public DateExtractConstantEvaluator get(DriverContext context) {
            return new DateExtractConstantEvaluator(this.source, this.value.get(context), this.chronoField, this.zone, context);
        }

        public String toString() {
            return "DateExtractConstantEvaluator[value=" + this.value + ", chronoField=" + this.chronoField + ", zone=" + this.zone + "]";
        }
    }
}

