/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlConfigurationFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractConstantEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtractEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.session.Configuration;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class DateExtract
extends EsqlConfigurationFunction {
    private ChronoField chronoField;

    @FunctionInfo(returnType={"long"}, description="Extracts parts of a date, like year, month, day, hour.")
    public DateExtract(Source source, @Param(name="datePart", type={"keyword", "text"}, description="Part of the date to extract.\nCan be: aligned_day_of_week_in_month; aligned_day_of_week_in_year; aligned_week_of_month;\naligned_week_of_year; ampm_of_day; clock_hour_of_ampm; clock_hour_of_day; day_of_month; day_of_week;\nday_of_year; epoch_day; era; hour_of_ampm; hour_of_day; instant_seconds; micro_of_day; micro_of_second;\nmilli_of_day; milli_of_second; minute_of_day; minute_of_hour; month_of_year; nano_of_day; nano_of_second;\noffset_seconds; proleptic_month; second_of_day; second_of_minute; year; or year_of_era.") Expression chronoFieldExp, @Param(name="date", type={"date"}, description="Date expression") Expression field, Configuration configuration) {
        super(source, List.of(chronoFieldExp, field), configuration);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory fieldEvaluator = toEvaluator.apply((Expression)this.children().get(1));
        if (((Expression)this.children().get(0)).foldable()) {
            ChronoField chrono = this.chronoField();
            if (chrono == null) {
                BytesRef field = (BytesRef)((Expression)this.children().get(0)).fold();
                throw new InvalidArgumentException("invalid date field for [{}]: {}", new Object[]{this.sourceText(), field.utf8ToString()});
            }
            return new DateExtractConstantEvaluator.Factory(this.source(), fieldEvaluator, chrono, this.configuration().zoneId());
        }
        EvalOperator.ExpressionEvaluator.Factory chronoEvaluator = toEvaluator.apply((Expression)this.children().get(0));
        return new DateExtractEvaluator.Factory(this.source(), fieldEvaluator, chronoEvaluator, this.configuration().zoneId());
    }

    private ChronoField chronoField() {
        if (this.chronoField == null) {
            Expression field = (Expression)this.children().get(0);
            try {
                if (field.foldable() && EsqlDataTypes.isString(field.dataType())) {
                    this.chronoField = (ChronoField)EsqlDataTypeConverter.EsqlConverter.STRING_TO_CHRONO_FIELD.convert(field.fold());
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.chronoField;
    }

    static long process(long value, BytesRef chronoField, ZoneId zone) {
        return EsqlDataTypeConverter.chronoToLong(value, chronoField, zone);
    }

    static long process(long value, ChronoField chronoField, ZoneId zone) {
        return EsqlDataTypeConverter.chronoToLong(value, chronoField, zone);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new DateExtract(this.source(), newChildren.get(0), newChildren.get(1), this.configuration());
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, DateExtract::new, (Object)((Expression)this.children().get(0)), (Object)((Expression)this.children().get(1)), (Object)this.configuration());
    }

    public DataType dataType() {
        return DataTypes.LONG;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return EsqlTypeResolutions.isStringAndExact((Expression)this.children().get(0), this.sourceText(), TypeResolutions.ParamOrdinal.FIRST).and(TypeResolutions.isDate((Expression)((Expression)this.children().get(1)), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    public boolean foldable() {
        return ((Expression)this.children().get(0)).foldable() && ((Expression)this.children().get(1)).foldable();
    }
}

