/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.date;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class BinaryDateTimeFunction
extends BinaryScalarFunction {
    protected static final ZoneId DEFAULT_TZ = ZoneOffset.UTC;
    private final ZoneId zoneId = DEFAULT_TZ;

    protected BinaryDateTimeFunction(Source source, Expression argument, Expression timestamp) {
        super(source, argument, timestamp);
    }

    public DataType dataType() {
        return DataTypes.DATETIME;
    }

    public Expression timestampField() {
        return this.right();
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.zoneId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryDateTimeFunction that = (BinaryDateTimeFunction)((Object)o);
        return this.zoneId().equals(that.zoneId());
    }
}

