/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLongFromStringEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToUnsignedLong
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.UNSIGNED_LONG, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.DATETIME, ToUnsignedLongFromLongEvaluator.Factory::new), Map.entry(DataTypes.BOOLEAN, ToUnsignedLongFromBooleanEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, ToUnsignedLongFromStringEvaluator.Factory::new), Map.entry(DataTypes.TEXT, ToUnsignedLongFromStringEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, ToUnsignedLongFromDoubleEvaluator.Factory::new), Map.entry(DataTypes.LONG, ToUnsignedLongFromLongEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, ToUnsignedLongFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"unsigned_long"}, description="Converts an input value to an unsigned long value.")
    public ToUnsignedLong(Source source, @Param(name="field", type={"boolean", "date", "keyword", "text", "double", "long", "unsigned_long", "integer"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.UNSIGNED_LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToUnsignedLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToUnsignedLong::new, (Object)this.field());
    }

    static long fromBoolean(boolean bool) {
        return EsqlDataTypeConverter.booleanToUnsignedLong(bool);
    }

    static long fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToUnsignedLong(in.utf8ToString());
    }

    static long fromDouble(double dbl) {
        return EsqlDataTypeConverter.doubleToUnsignedLong(dbl);
    }

    static long fromLong(long lng) {
        return EsqlDataTypeConverter.longToUnsignedLong(lng, false);
    }

    static long fromInt(int i) {
        return EsqlDataTypeConverter.intToUnsignedLong(i);
    }
}

