/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.List;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromStringEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLongFromUnsignedLongEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypeConverter;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class ToLong
extends AbstractConvertFunction {
    private static final Map<DataType, AbstractConvertFunction.BuildFactory> EVALUATORS = Map.ofEntries(Map.entry(DataTypes.LONG, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.DATETIME, (fieldEval, source) -> fieldEval), Map.entry(DataTypes.BOOLEAN, ToLongFromBooleanEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, ToLongFromStringEvaluator.Factory::new), Map.entry(DataTypes.TEXT, ToLongFromStringEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, ToLongFromDoubleEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, ToLongFromUnsignedLongEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, ToLongFromIntEvaluator.Factory::new));

    @FunctionInfo(returnType={"long"}, description="Converts an input value to a long value.")
    public ToLong(Source source, @Param(name="field", type={"boolean", "date", "keyword", "text", "double", "long", "unsigned_long", "integer"}) Expression field) {
        super(source, field);
    }

    @Override
    protected Map<DataType, AbstractConvertFunction.BuildFactory> factories() {
        return EVALUATORS;
    }

    @Override
    public DataType dataType() {
        return DataTypes.LONG;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new ToLong(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, ToLong::new, (Object)this.field());
    }

    static long fromBoolean(boolean bool) {
        return bool ? 1L : 0L;
    }

    static long fromKeyword(BytesRef in) {
        return EsqlDataTypeConverter.stringToLong(in.utf8ToString());
    }

    static long fromDouble(double dbl) {
        return DataTypeConverter.safeDoubleToLong((double)dbl);
    }

    static long fromUnsignedLong(long ul) {
        return EsqlDataTypeConverter.unsignedLongToLong(ul);
    }

    static long fromInt(int i) {
        return i;
    }
}

