/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.ql.tree.Source;

public final class ToDoubleFromIntEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    public ToDoubleFromIntEvaluator(EvalOperator.ExpressionEvaluator field, Source source, DriverContext driverContext) {
        super(driverContext, field, source);
    }

    @Override
    public String name() {
        return "ToDoubleFromInt";
    }

    @Override
    public Block evalVector(Vector v) {
        IntVector vector = (IntVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantDoubleBlockWith(ToDoubleFromIntEvaluator.evalValue(vector, 0), positionCount);
        }
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendDouble(ToDoubleFromIntEvaluator.evalValue(vector, p));
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private static double evalValue(IntVector container, int index) {
        int value = container.getInt(index);
        return ToDouble.fromInt(value);
    }

    @Override
    public Block evalBlock(Block b) {
        IntBlock block = (IntBlock)b;
        int positionCount = block.getPositionCount();
        try (DoubleBlock.Builder builder = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    double value = ToDoubleFromIntEvaluator.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendDouble(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            DoubleBlock doubleBlock = builder.build();
            return doubleBlock;
        }
    }

    private static double evalValue(IntBlock container, int index) {
        int value = container.getInt(index);
        return ToDouble.fromInt(value);
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;

        public Factory(EvalOperator.ExpressionEvaluator.Factory field, Source source) {
            this.field = field;
            this.source = source;
        }

        public ToDoubleFromIntEvaluator get(DriverContext context) {
            return new ToDoubleFromIntEvaluator(this.field.get(context), this.source, context);
        }

        public String toString() {
            return "ToDoubleFromIntEvaluator[field=" + this.field + "]";
        }
    }
}

