/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.EsqlScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastBooleanEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastBytesRefEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastDoubleEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastIntEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.LeastLongEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Expressions;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class Least
extends EsqlScalarFunction
implements OptionalArgument {
    private DataType dataType;

    @FunctionInfo(returnType={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}, description="Returns the minimum value from many columns.")
    public Least(Source source, @Param(name="first", type={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}) Expression first, @Param(name="rest", type={"integer", "long", "double", "boolean", "keyword", "text", "ip", "version"}, optional=true) List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        for (int position = 0; position < this.children().size(); ++position) {
            Expression child = (Expression)this.children().get(position);
            if (this.dataType == null || this.dataType == DataTypes.NULL) {
                this.dataType = child.dataType();
                continue;
            }
            Expression.TypeResolution resolution = TypeResolutions.isType((Expression)child, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return Expression.TypeResolution.TYPE_RESOLVED;
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Least(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Least::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        return Expressions.foldable((List)this.children());
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        DataType dataType = this.dataType();
        EvalOperator.ExpressionEvaluator.Factory[] factories = (EvalOperator.ExpressionEvaluator.Factory[])this.children().stream().map(e -> (EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply((Expression)new MvMin(e.source(), (Expression)e))).toArray(EvalOperator.ExpressionEvaluator.Factory[]::new);
        if (dataType == DataTypes.BOOLEAN) {
            return new LeastBooleanEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.DOUBLE) {
            return new LeastDoubleEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.INTEGER) {
            return new LeastIntEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.LONG) {
            return new LeastLongEvaluator.Factory(this.source(), factories);
        }
        if (dataType == DataTypes.KEYWORD || dataType == DataTypes.TEXT || dataType == DataTypes.IP || dataType == DataTypes.VERSION || dataType == DataTypes.UNSUPPORTED) {
            return new LeastBytesRefEvaluator.Factory(this.source(), factories);
        }
        throw EsqlIllegalArgumentException.illegalDataType(dataType);
    }

    static boolean process(boolean[] values) {
        for (boolean v : values) {
            if (v) continue;
            return false;
        }
        return true;
    }

    static BytesRef process(BytesRef[] values) {
        BytesRef min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = min.compareTo(values[i]) < 0 ? min : values[i];
        }
        return min;
    }

    static int process(int[] values) {
        int min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    static long process(long[] values) {
        long min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }

    static double process(double[] values) {
        double min = values[0];
        for (int i = 1; i < values.length; ++i) {
            min = Math.min(min, values[i]);
        }
        return min;
    }
}

