/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.util.Arrays;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;
import org.elasticsearch.xpack.ql.tree.Source;

public final class GreatestIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private final Warnings warnings;
    private final EvalOperator.ExpressionEvaluator[] values;
    private final DriverContext driverContext;

    public GreatestIntEvaluator(Source source, EvalOperator.ExpressionEvaluator[] values, DriverContext driverContext) {
        this.warnings = new Warnings(source);
        this.values = values;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        IntBlock[] valuesBlocks = new IntBlock[this.values.length];
        try (Releasable valuesRelease = Releasables.wrap((Releasable[])valuesBlocks);){
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesBlocks[i] = (IntBlock)this.values[i].eval(page);
            }
            IntVector[] valuesVectors = new IntVector[this.values.length];
            for (int i = 0; i < valuesBlocks.length; ++i) {
                valuesVectors[i] = valuesBlocks[i].asVector();
                if (valuesVectors[i] != null) continue;
                IntBlock intBlock = this.eval(page.getPositionCount(), valuesBlocks);
                return intBlock;
            }
            IntBlock intBlock = this.eval(page.getPositionCount(), valuesVectors).asBlock();
            return intBlock;
        }
    }

    public IntBlock eval(int positionCount, IntBlock[] valuesBlocks) {
        try (IntBlock.Builder result = this.driverContext.blockFactory().newIntBlockBuilder(positionCount);){
            int[] valuesValues = new int[this.values.length];
            block5: for (int p = 0; p < positionCount; ++p) {
                int i;
                for (i = 0; i < valuesBlocks.length; ++i) {
                    if (valuesBlocks[i].isNull(p)) {
                        result.appendNull();
                        continue block5;
                    }
                    if (valuesBlocks[i].getValueCount(p) == 1) continue;
                    if (valuesBlocks[i].getValueCount(p) > 1) {
                        this.warnings.registerException(new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue block5;
                }
                for (i = 0; i < valuesBlocks.length; ++i) {
                    int o = valuesBlocks[i].getFirstValueIndex(p);
                    valuesValues[i] = valuesBlocks[i].getInt(o);
                }
                result.appendInt(Greatest.process(valuesValues));
            }
            IntBlock intBlock = result.build();
            return intBlock;
        }
    }

    public IntVector eval(int positionCount, IntVector[] valuesVectors) {
        try (IntVector.Builder result = this.driverContext.blockFactory().newIntVectorBuilder(positionCount);){
            int[] valuesValues = new int[this.values.length];
            for (int p = 0; p < positionCount; ++p) {
                for (int i = 0; i < valuesVectors.length; ++i) {
                    valuesValues[i] = valuesVectors[i].getInt(p);
                }
                result.appendInt(Greatest.process(valuesValues));
            }
            IntVector intVector = result.build();
            return intVector;
        }
    }

    public String toString() {
        return "GreatestIntEvaluator[values=" + Arrays.toString(this.values) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException(() -> Releasables.close((Releasable[])this.values));
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory[] values;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory[] values) {
            this.source = source;
            this.values = values;
        }

        public GreatestIntEvaluator get(DriverContext context) {
            EvalOperator.ExpressionEvaluator[] values = (EvalOperator.ExpressionEvaluator[])Arrays.stream(this.values).map(a -> a.get(context)).toArray(EvalOperator.ExpressionEvaluator[]::new);
            return new GreatestIntEvaluator(this.source, values, context);
        }

        public String toString() {
            return "GreatestIntEvaluator[values=" + Arrays.toString(this.values) + "]";
        }
    }
}

