/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidCartesianPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidGeoPointDocValuesAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.spatial.SpatialCentroidGeoPointSourceValuesAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.planner.ToAggregator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.aggregate.SpatialAggregateFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;

public class SpatialCentroid
extends SpatialAggregateFunction
implements ToAggregator {
    @FunctionInfo(returnType={"geo_point", "cartesian_point"}, description="The centroid of a spatial field.", isAggregation=true)
    public SpatialCentroid(Source source, @Param(name="field", type={"geo_point", "cartesian_point"}) Expression field) {
        super(source, field, false);
    }

    private SpatialCentroid(Source source, Expression field, boolean useDocValues) {
        super(source, field, useDocValues);
    }

    public SpatialCentroid withDocValues() {
        return new SpatialCentroid(this.source(), this.field(), true);
    }

    protected Expression.TypeResolution resolveType() {
        return EsqlTypeResolutions.isSpatialPoint(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public DataType dataType() {
        return this.field().dataType();
    }

    protected NodeInfo<SpatialCentroid> info() {
        return NodeInfo.create((Node)this, SpatialCentroid::new, (Object)this.field());
    }

    public SpatialCentroid replaceChildren(List<Expression> newChildren) {
        return new SpatialCentroid(this.source(), newChildren.get(0));
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        DataType type = this.field().dataType();
        if (this.useDocValues) {
            if (type == EsqlDataTypes.GEO_POINT) {
                return new SpatialCentroidGeoPointDocValuesAggregatorFunctionSupplier(inputChannels);
            }
            if (type == EsqlDataTypes.CARTESIAN_POINT) {
                return new SpatialCentroidCartesianPointDocValuesAggregatorFunctionSupplier(inputChannels);
            }
        } else {
            if (type == EsqlDataTypes.GEO_POINT) {
                return new SpatialCentroidGeoPointSourceValuesAggregatorFunctionSupplier(inputChannels);
            }
            if (type == EsqlDataTypes.CARTESIAN_POINT) {
                return new SpatialCentroidCartesianPointSourceValuesAggregatorFunctionSupplier(inputChannels);
            }
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

