/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.expression.SurrogateExpression;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvDedupe;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.planner.ToAggregator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class CountDistinct
extends AggregateFunction
implements OptionalArgument,
ToAggregator,
SurrogateExpression {
    private static final int DEFAULT_PRECISION = 3000;
    private final Expression precision;

    @FunctionInfo(returnType={"long"}, description="Returns the approximate number of distinct values.", isAggregation=true)
    public CountDistinct(Source source, @Param(name="field", type={"boolean", "cartesian_point", "date", "double", "geo_point", "integer", "ip", "keyword", "long", "text", "version"}, description="Column or literal for which to count the number of distinct values.") Expression field, @Param(optional=true, name="precision", type={"integer"}) Expression precision) {
        super(source, field, precision != null ? List.of(precision) : List.of());
        this.precision = precision;
    }

    protected NodeInfo<CountDistinct> info() {
        return NodeInfo.create((Node)this, CountDistinct::new, (Object)this.field(), (Object)this.precision);
    }

    public CountDistinct replaceChildren(List<Expression> newChildren) {
        return new CountDistinct(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    public DataType dataType() {
        return DataTypes.LONG;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = EsqlTypeResolutions.isExact(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
        if (resolution.unresolved()) {
            return resolution;
        }
        boolean resolved = resolution.resolved();
        resolution = TypeResolutions.isType((Expression)this.field(), dt -> resolved && dt != DataTypes.UNSIGNED_LONG, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT, (String[])new String[]{"any exact type except unsigned_long"});
        if (resolution.unresolved() || this.precision == null) {
            return resolution;
        }
        return TypeResolutions.isInteger((Expression)this.precision, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isFoldable((Expression)this.precision, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    @Override
    public AggregatorFunctionSupplier supplier(List<Integer> inputChannels) {
        int precision;
        DataType type = this.field().dataType();
        int n = precision = this.precision == null ? 3000 : ((Number)this.precision.fold()).intValue();
        if (type == DataTypes.BOOLEAN) {
            return new CountDistinctBooleanAggregatorFunctionSupplier(inputChannels);
        }
        if (type == DataTypes.DATETIME || type == DataTypes.LONG) {
            return new CountDistinctLongAggregatorFunctionSupplier(inputChannels, precision);
        }
        if (type == DataTypes.INTEGER) {
            return new CountDistinctIntAggregatorFunctionSupplier(inputChannels, precision);
        }
        if (type == DataTypes.DOUBLE) {
            return new CountDistinctDoubleAggregatorFunctionSupplier(inputChannels, precision);
        }
        if (type == DataTypes.KEYWORD || type == DataTypes.IP || type == DataTypes.VERSION || type == DataTypes.TEXT) {
            return new CountDistinctBytesRefAggregatorFunctionSupplier(inputChannels, precision);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }

    @Override
    public Expression surrogate() {
        Source s = this.source();
        Expression field = this.field();
        return field.foldable() ? new ToLong(s, (Expression)new Coalesce(s, (Expression)new MvCount(s, (Expression)new MvDedupe(s, field)), List.of(new Literal(s, (Object)0, DataTypes.INTEGER)))) : null;
    }
}

