/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsGeometriesEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.evaluator.predicate.operator.comparison.NotEqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.Negatable;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparison;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.BinaryComparisonProcessor;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class NotEquals
extends EsqlBinaryComparison
implements Negatable<BinaryComparison> {
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataTypes.BOOLEAN, NotEqualsBoolsEvaluator.Factory::new), Map.entry(DataTypes.INTEGER, NotEqualsIntsEvaluator.Factory::new), Map.entry(DataTypes.DOUBLE, NotEqualsDoublesEvaluator.Factory::new), Map.entry(DataTypes.LONG, NotEqualsLongsEvaluator.Factory::new), Map.entry(DataTypes.UNSIGNED_LONG, NotEqualsLongsEvaluator.Factory::new), Map.entry(DataTypes.DATETIME, NotEqualsLongsEvaluator.Factory::new), Map.entry(EsqlDataTypes.GEO_POINT, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(EsqlDataTypes.CARTESIAN_POINT, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(EsqlDataTypes.GEO_SHAPE, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(EsqlDataTypes.CARTESIAN_SHAPE, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(DataTypes.KEYWORD, NotEqualsKeywordsEvaluator.Factory::new), Map.entry(DataTypes.TEXT, NotEqualsKeywordsEvaluator.Factory::new), Map.entry(DataTypes.VERSION, NotEqualsKeywordsEvaluator.Factory::new), Map.entry(DataTypes.IP, NotEqualsKeywordsEvaluator.Factory::new));

    public NotEquals(Source source, Expression left, Expression right) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.NEQ, evaluatorMap);
    }

    public NotEquals(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, BinaryComparisonProcessor.BinaryComparisonOperation.NEQ, zoneId, evaluatorMap);
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs != rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs != rhs;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs != rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return false == lhs.equals((Object)rhs);
    }

    static boolean processBools(boolean lhs, boolean rhs) {
        return lhs != rhs;
    }

    static boolean processGeometries(BytesRef lhs, BytesRef rhs) {
        return false == lhs.equals((Object)rhs);
    }

    public BinaryComparison reverse() {
        return this;
    }

    protected NodeInfo<NotEquals> info() {
        return NodeInfo.create((Node)this, NotEquals::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected NotEquals replaceChildren(Expression newLeft, Expression newRight) {
        return new NotEquals(this.source(), newLeft, newRight, this.zoneId());
    }

    public NotEquals swapLeftAndRight() {
        return new NotEquals(this.source(), this.right(), this.left(), this.zoneId());
    }

    public BinaryComparison negate() {
        return new Equals(this.source(), this.left(), this.right(), this.zoneId());
    }
}

